package io.pdfire.client

/**
 * Common paper formats provide [ConversionParameters.paperWidth] and [ConversionParameters.paperHeight] shortcuts.
 */
enum class PaperFormat
{
    /**
     * "letter" paper format.
     */
    Letter,

    /**
     * "legal" paper format.
     */
    Legal,

    /**
     * "tabloid" paper format.
     */
    Tabloid,

    /**
     * "ledger" paper format.
     */
    Ledger,

    /**
     * "A0" paper format.
     */
    A0,

    /**
     * "A1" paper format.
     */
    A1,

    /**
     * "A2" paper format.
     */
    A2,

    /**
     * "A3" paper format.
     */
    A3,

    /**
     * "A4" paper format.
     */
    A4,

    /**
     * "A5" paper format.
     */
    A5,

    /**
     * "A6" paper format.
     */
    A6;

    /**
     * Get the string value of the option.
     */
    override fun toString(): String = when (this) {
        Letter -> "letter"
        Legal -> "legal"
        Tabloid -> "tabloid"
        Ledger -> "ledger"
        A0 -> "a0"
        A1 -> "a1"
        A2 -> "a2"
        A3 -> "a3"
        A4 -> "a4"
        A5 -> "a5"
        A6 -> "a6"
    }
}
