package io.pdfire.client

/**
 * Interface for conversion parameters.
 */
interface Parameters
{
    /**
     * Serve the PDF via the PDFire.io CDN.
     */
    var cdn: Boolean?

    /**
     * Storage configuration for the PDF.
     */
    var storage: StorageParameter?

    /**
     * Create a map from the parameters.
     */
    fun toMap(): Map<String, Any?>
}
