package io.pdfire.client

/**
 * CSS media types that can be emulated.
 */
enum class Media
{
    /**
     * "screen" media type.
     */
    Screen,

    /**
     * "print" media type.
     */
    Print;

    /**
     * Get the string value of the option.
     */
    override fun toString() = when (this) {
        Screen -> "screen"
        Print -> "print"
    }
}
