package io.pdfire.client

/**
 * Options for the [ConversionParameters.waitUntil] option.
 */
enum class WaitUntil
{
    /**
     * "load" browser event.
     */
    Load,

    /**
     * "DOMContentLoaded" browser event.
     */
    DOM;

    /**
     * Get the string value of the option.
     */
    override fun toString(): String = when (this) {
        Load -> "load"
        DOM -> "dom"
    }
}
