package io.pdfire.client

/**
 * Interface for conversion parameters.
 */
interface Parameters
{
    /**
     * Set the CDN option.
     */
    fun setCdn(cdn: Boolean = true): Parameters

    /**
     * Serve the PDF via a custom cloud storage disk.
     */
    fun useStorage(configure: ((StorageParameter) -> Unit)?): Parameters

    /**
     * Serve the PDF via the default custom cloud storage disk.
     */
    fun useStorage(use: Boolean = true): Parameters

    /**
     * Create a map from the parameters.
     */
    fun toMap(): Map<String, Any?>
}
