package io.pdfire.client

/**
 * Storage disk configuration.
 *
 * @property disk Storage disk ID (<a href="https://pdfire.io/account/storage">Storage settings</a>).
 * @property path Storage path.
 */
data class StorageParameter(var disk: String = "", var path: String = "")
{
    /**
     * Create a map from the parameter.
     */
    fun toMap(): Map<String, Any?> = mapOf(
        Pair("disk", if (disk.isNotEmpty()) disk else null),
        Pair("path", if (path.isNotEmpty()) path else null)
    ).filter { it.value != null }
}
