/*
 * Decompiled with CFR 0.152.
 */
package io.pdfdata;

import com.fasterxml.jackson.core.type.TypeReference;
import io.pdfdata.API;
import io.pdfdata.Network;
import io.pdfdata.Request;
import io.pdfdata.Util;
import io.pdfdata.model.Document;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class DocumentsRequest
extends Request {
    private static final String base = "documents";
    private static final TypeReference<Document> TYPEREF = new TypeReference<Document>(){};
    private static final TypeReference<List<Document>> TYPEREF_LIST = new TypeReference<List<Document>>(){};

    DocumentsRequest(API pdfdata) {
        super(pdfdata);
    }

    public Document byID(String docid) throws IOException {
        return this.doRequest(Network.Method.GET, "documents/" + docid, TYPEREF);
    }

    public List<Document> list() throws IOException {
        return this.list(Instant.ofEpochMilli(4102444799000L));
    }

    public List<Document> list(Instant createdBefore) throws IOException {
        return this.doRequest(Network.Method.GET, base, Util.kvmap("before", createdBefore), TYPEREF_LIST);
    }

    public List<Document> upload(File ... files) throws IOException {
        return this.upload(null, Arrays.asList(files));
    }

    public List<Document> upload(Collection<File> files) throws IOException {
        return this.upload(null, files);
    }

    public List<Document> upload(Collection<String> tags, Collection<File> files) throws IOException {
        return this.doRequest(Network.Method.POST, base, Util.kvmap("tag", Util.setFrom(tags), "file", files), TYPEREF_LIST);
    }
}

