/*
 * Decompiled with CFR 0.152.
 */
package io.pdal;

import io.pdal.DimType;
import io.pdal.DimType$;
import io.pdal.Native;
import io.pdal.PointCloud;
import io.pdal.PointCloud$;
import io.pdal.PointLayout;
import io.pdal.TriangularMesh;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public class PointView
implements Native {
    private long nativeHandle;

    public PointView() {
        Native.$init$(this);
    }

    @Override
    public long nativeHandle() {
        return this.nativeHandle;
    }

    @Override
    public void nativeHandle_$eq(long x$1) {
        this.nativeHandle = x$1;
    }

    public PointCloud getPointCloud(long idx) {
        return this.getPointCloud(idx, this.layout().dimTypes());
    }

    public PointCloud getPointCloud(long idx, DimType[] dims) {
        return PointCloud$.MODULE$.apply(this.getPackedPoint(idx, dims), this.layout().toSizedDimTypes(dims));
    }

    public PointCloud getPointCloud() {
        return this.getPointCloud(this.layout().dimTypes());
    }

    public PointCloud getPointCloud(DimType[] dims) {
        return PointCloud$.MODULE$.apply(this.getPackedPoints(dims), this.layout().toSizedDimTypes(dims));
    }

    public byte[] getPackedPoint(long idx) {
        return this.getPackedPoint(idx, this.layout().dimTypes());
    }

    public byte[] getPackedPoints() {
        return this.getPackedPoints(this.layout().dimTypes());
    }

    public DimType findDimType(String name) {
        return this.layout().findDimType(name);
    }

    public int length() {
        return this.size();
    }

    public String getCrsWKT() {
        return this.getCrsWKT(false);
    }

    public byte[] get(int idx, byte[] packedPoints) {
        return this.get(idx, packedPoints, this.layout().dimTypes());
    }

    public byte[] get(int idx, byte[] packedPoints, DimType[] dims) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])dims);
        int pointSize = (int)BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> this.layout().dimSize((DimType)_$1), ClassTag$.MODULE$.apply(Long.TYPE))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        int from = idx * pointSize;
        byte[] result = new byte[pointSize];
        for (int j = 0; j < pointSize; ++j) {
            result[j] = packedPoints[from + j];
        }
        return result;
    }

    public ByteBuffer get(byte[] packedPoint, DimType dim) {
        int from = (int)this.layout().dimPackedOffset(dim);
        int dimSize = (int)this.layout().dimSize(dim);
        byte[] result = new byte[dimSize];
        for (int j = 0; j < dimSize; ++j) {
            result[j] = packedPoint[from + j];
        }
        return ByteBuffer.wrap(result).order(ByteOrder.nativeOrder());
    }

    public double getDouble(byte[] packedPoint, String dim) {
        return this.getDouble(packedPoint, this.findDimType(dim));
    }

    public double getDouble(byte[] packedPoint, DimType dim) {
        return this.get(packedPoint, dim).getDouble();
    }

    public float getFloat(byte[] packedPoint, String dim) {
        return this.getFloat(packedPoint, this.findDimType(dim));
    }

    public float getFloat(byte[] packedPoint, DimType dim) {
        return this.get(packedPoint, dim).getFloat();
    }

    public long getLong(byte[] packedPoint, String dim) {
        return this.getLong(packedPoint, this.findDimType(dim));
    }

    public long getLong(byte[] packedPoint, DimType dim) {
        return this.get(packedPoint, dim).getLong();
    }

    public int getInt(byte[] packedPoint, String dim) {
        return this.getInt(packedPoint, this.findDimType(dim));
    }

    public int getInt(byte[] packedPoint, DimType dim) {
        return this.get(packedPoint, dim).getInt();
    }

    public short getShort(byte[] packedPoint, String dim) {
        return this.getShort(packedPoint, this.findDimType(dim));
    }

    public short getShort(byte[] packedPoint, DimType dim) {
        return this.get(packedPoint, dim).getShort();
    }

    public char getChar(byte[] packedPoint, String dim) {
        return this.getChar(packedPoint, this.findDimType(dim));
    }

    public char getChar(byte[] packedPoint, DimType dim) {
        return this.get(packedPoint, dim).getChar();
    }

    public byte getByte(byte[] packedPoint, String dim) {
        return this.getByte(packedPoint, this.findDimType(dim));
    }

    public byte getByte(byte[] packedPoint, DimType dim) {
        return this.get(packedPoint, dim).get();
    }

    public double getDouble(int idx, String dim) {
        return this.getDouble(idx, this.findDimType(dim));
    }

    public double getDouble(int idx, DimType dim) {
        return this.get(idx, dim).getDouble();
    }

    public float getFloat(int idx, String dim) {
        return this.getFloat(idx, this.findDimType(dim));
    }

    public float getFloat(int idx, DimType dim) {
        return this.get(idx, dim).getFloat();
    }

    public long getLong(int idx, String dim) {
        return this.getLong(idx, this.findDimType(dim));
    }

    public long getLong(int idx, DimType dim) {
        return this.get(idx, dim).getLong();
    }

    public int getInt(int idx, String dim) {
        return this.getInt(idx, this.findDimType(dim));
    }

    public int getInt(int idx, DimType dim) {
        return this.get(idx, dim).getInt();
    }

    public short getShort(int idx, String dim) {
        return this.getShort(idx, this.findDimType(dim));
    }

    public short getShort(int idx, DimType dim) {
        return this.get(idx, dim).getShort();
    }

    public char getChar(int idx, String dim) {
        return this.getChar(idx, this.findDimType(dim));
    }

    public char getChar(int idx, DimType dim) {
        return this.get(idx, dim).getChar();
    }

    public byte getByte(int idx, String dim) {
        return this.getByte(idx, this.findDimType(dim));
    }

    public byte getByte(int idx, DimType dim) {
        return this.get(idx, dim).get();
    }

    public ByteBuffer get(int idx, String dim) {
        return this.get(idx, this.findDimType(dim));
    }

    public ByteBuffer get(int idx, DimType dim) {
        return ByteBuffer.wrap(this.getPackedPoint(Int$.MODULE$.int2long(idx), new DimType[]{dim})).order(ByteOrder.nativeOrder());
    }

    public double getX(int idx) {
        return this.getDouble(idx, DimType$.MODULE$.X());
    }

    public double getY(int idx) {
        return this.getDouble(idx, DimType$.MODULE$.Y());
    }

    public double getZ(int idx) {
        return this.getDouble(idx, DimType$.MODULE$.Z());
    }

    public double getX(byte[] packedPoint) {
        return this.getDouble(packedPoint, DimType$.MODULE$.X());
    }

    public double getY(byte[] packedPoint) {
        return this.getDouble(packedPoint, DimType$.MODULE$.Y());
    }

    public double getZ(byte[] packedPoint) {
        return this.getDouble(packedPoint, DimType$.MODULE$.Z());
    }

    public TriangularMesh getTriangularMesh() {
        return this.getTriangularMesh("");
    }

    public double[] rasterizeTriangularMesh(double[] extent, int cols, int rows) {
        return this.rasterizeTriangularMesh(extent, cols, rows, DimType$.MODULE$.Z());
    }

    public double[] rasterizeTriangularMesh(double[] extent, int cols, int rows, String dim) {
        return this.rasterizeTriangularMesh(extent, cols, rows, this.findDimType(dim));
    }

    public double[] rasterizeTriangularMesh(double[] extent, int cols, int rows, DimType dim) {
        return this.rasterizeTriangularMesh(extent, cols, rows, dim, "");
    }

    public native PointLayout layout();

    public native int size();

    public native boolean empty();

    public native String getCrsProj4();

    public native String getCrsWKT(boolean var1);

    public native byte[] getPackedPoint(long var1, DimType[] var3);

    public native byte[] getPackedPoints(DimType[] var1);

    public native TriangularMesh getTriangularMesh(String var1);

    public native double[] rasterizeTriangularMesh(double[] var1, int var2, int var3, DimType var4, String var5);

    @Override
    public native void close();
}

