/*
 * Decompiled with CFR 0.152.
 */
package io.pdal;

import io.pdal.DimType;
import io.pdal.DimType$Id$;
import io.pdal.PointCloud$;
import io.pdal.SizedDimType;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class PointCloud
implements Product,
Serializable {
    private final byte[] bytes;
    private final Map dimTypes;
    private final int pointSize;
    private final int length;
    private final boolean isPoint;

    public static PointCloud apply(byte[] byArray, Map<String, SizedDimType> map) {
        return PointCloud$.MODULE$.apply(byArray, map);
    }

    public static PointCloud fromProduct(Product product) {
        return PointCloud$.MODULE$.fromProduct(product);
    }

    public static PointCloud unapply(PointCloud pointCloud) {
        return PointCloud$.MODULE$.unapply(pointCloud);
    }

    public PointCloud(byte[] bytes, Map<String, SizedDimType> dimTypes) {
        this.bytes = bytes;
        this.dimTypes = dimTypes;
        this.pointSize = (int)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(dimTypes.values()).asScala()).map((Function1 & Serializable)_$1 -> _$1.size())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        this.length = bytes.length / this.pointSize();
        this.isPoint = this.length() == 1;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof PointCloud)) return false;
        PointCloud pointCloud = (PointCloud)object;
        if (this.bytes() != pointCloud.bytes()) return false;
        Map<String, SizedDimType> map = this.dimTypes();
        Map<String, SizedDimType> map2 = pointCloud.dimTypes();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!((Object)map).equals(map2)) return false;
        if (!pointCloud.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof PointCloud;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "PointCloud";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        if (0 == n2) {
            object = this._1();
        } else if (1 == n2) {
            object = this._2();
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "bytes";
        } else if (1 == n2) {
            string = "dimTypes";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public Map<String, SizedDimType> dimTypes() {
        return this.dimTypes;
    }

    public int pointSize() {
        return this.pointSize;
    }

    public int length() {
        return this.length;
    }

    public boolean isPoint() {
        return this.isPoint;
    }

    public long dimSize(SizedDimType dim) {
        return ((SizedDimType)((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.dimTypes()).asScala()).apply((Object)dim.dimType().id())).size();
    }

    public long dimSize(DimType dim) {
        return ((SizedDimType)((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.dimTypes()).asScala()).apply((Object)dim.id())).size();
    }

    public long dimSize(String dim) {
        return ((SizedDimType)((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.dimTypes()).asScala()).apply((Object)dim)).size();
    }

    public DimType findDimType(String dim) {
        return ((SizedDimType)((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.dimTypes()).asScala()).apply((Object)dim)).dimType();
    }

    public SizedDimType findSizedDimType(String dim) {
        return (SizedDimType)((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.dimTypes()).asScala()).apply((Object)dim);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] get(int i) {
        byte[] byArray;
        if (this.isPoint()) {
            byArray = this.bytes();
        } else {
            void var3_3;
            int from = i * this.pointSize();
            byte[] result = new byte[this.pointSize()];
            for (int j = 0; j < this.pointSize(); ++j) {
                result[j] = this.bytes()[from + j];
            }
            byArray = var3_3;
        }
        return byArray;
    }

    public double getDouble(int idx, SizedDimType dim) {
        return this.getDouble(idx, dim.dimType());
    }

    public double getDouble(int idx, DimType dim) {
        return this.getDouble(idx, dim.id());
    }

    public double getDouble(int idx, String dim) {
        return this.get(idx, dim).getDouble();
    }

    public float getFloat(int idx, SizedDimType dim) {
        return this.getFloat(idx, dim.dimType().id());
    }

    public float getFloat(int idx, DimType dim) {
        return this.getFloat(idx, dim.id());
    }

    public float getFloat(int idx, String dim) {
        return this.get(idx, dim).getFloat();
    }

    public long getLong(int idx, SizedDimType dim) {
        return this.getLong(idx, dim.dimType().id());
    }

    public long getLong(int idx, DimType dim) {
        return this.getLong(idx, dim.id());
    }

    public long getLong(int idx, String dim) {
        return this.get(idx, dim).getLong();
    }

    public int getInt(int idx, SizedDimType dim) {
        return this.getInt(idx, dim.dimType().id());
    }

    public int getInt(int idx, DimType dim) {
        return this.getInt(idx, dim.id());
    }

    public int getInt(int idx, String dim) {
        return this.get(idx, dim).getInt();
    }

    public short getShort(int idx, SizedDimType dim) {
        return this.getShort(idx, dim.dimType().id());
    }

    public short getShort(int idx, DimType dim) {
        return this.getShort(idx, dim.id());
    }

    public short getShort(int idx, String dim) {
        return this.get(idx, dim).getShort();
    }

    public char getChar(int idx, SizedDimType dim) {
        return this.getChar(idx, dim.dimType().id());
    }

    public char getChar(int idx, DimType dim) {
        return this.getChar(idx, dim.id());
    }

    public char getChar(int idx, String dim) {
        return this.get(idx, dim).getChar();
    }

    public byte getByte(int idx, SizedDimType dim) {
        return this.getByte(idx, dim.dimType().id());
    }

    public byte getByte(int idx, DimType dim) {
        return this.getByte(idx, dim.id());
    }

    public byte getByte(int idx, String dim) {
        return this.get(idx, dim).get();
    }

    public ByteBuffer get(int idx, SizedDimType dim) {
        return this.get(idx, dim.dimType().id());
    }

    public ByteBuffer get(int idx, DimType dim) {
        return this.get(idx, dim.id());
    }

    public ByteBuffer get(int idx, String dim) {
        return ByteBuffer.wrap(this.get(this.get(idx), dim)).order(ByteOrder.nativeOrder());
    }

    public ByteBuffer get(int idx, SizedDimType[] dims) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])dims);
        return this.get(idx, (String[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$2 -> _$2.dimType().id(), ClassTag$.MODULE$.apply(String.class)));
    }

    public ByteBuffer get(int idx, DimType[] dims) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])dims);
        return this.get(idx, (String[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$3 -> _$3.id(), ClassTag$.MODULE$.apply(String.class)));
    }

    public ByteBuffer get(int idx, String[] dims) {
        return ByteBuffer.wrap(this.get(this.get(idx), dims)).order(ByteOrder.nativeOrder());
    }

    public double getX(int idx) {
        return this.getDouble(idx, DimType$Id$.MODULE$.X());
    }

    public double getY(int idx) {
        return this.getDouble(idx, DimType$Id$.MODULE$.Y());
    }

    public double getZ(int idx) {
        return this.getDouble(idx, DimType$Id$.MODULE$.Z());
    }

    public byte[] get(byte[] packedPoint, String dim) {
        SizedDimType sdt = (SizedDimType)((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.dimTypes()).asScala()).apply((Object)dim);
        int from = (int)sdt.offset();
        int dimSize = (int)sdt.size();
        byte[] result = new byte[dimSize];
        for (int j = 0; j < dimSize; ++j) {
            result[j] = packedPoint[from + j];
        }
        return result;
    }

    private byte[] get(byte[] packedPoint, String[] dims) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])dims);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$4 -> this.get(this.bytes(), (String)_$4), ClassTag$.MODULE$.apply(Byte.TYPE).wrap()));
        return (byte[])ArrayOps$.MODULE$.fold$extension(object2, (Object)new byte[0], (Function2 & Serializable)(_$5, _$6) -> {
            Object object = Predef$.MODULE$.byteArrayOps(_$5);
            return (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, _$6, ClassTag$.MODULE$.apply(Byte.TYPE));
        });
    }

    public PointCloud copy(byte[] bytes, Map<String, SizedDimType> dimTypes) {
        return new PointCloud(bytes, dimTypes);
    }

    public byte[] copy$default$1() {
        return this.bytes();
    }

    public Map<String, SizedDimType> copy$default$2() {
        return this.dimTypes();
    }

    public byte[] _1() {
        return this.bytes();
    }

    public Map<String, SizedDimType> _2() {
        return this.dimTypes();
    }
}

