package io.err0r.esaylistfragment;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import cn.bingoogolapple.androidcommon.adapter.BGAOnItemChildCheckedChangeListener;
import cn.bingoogolapple.androidcommon.adapter.BGAOnItemChildClickListener;
import cn.bingoogolapple.androidcommon.adapter.BGARecyclerViewAdapter;

/**
 * 文件名: EasyListFragment
 * 作者: pcyan
 * 日期: 16-10-1--上午11:43
 * 描述: 列表Fragment，只控制视图（刷新/加载），不控制数据
 */

public class EasyListFragment<M> extends Fragment {

    private SwipeRefreshLayout srl_refresh;
    private RecyclerView rv_list;

    private View view;

    private BGARecyclerViewAdapter<M> mAdapter;
    private Class<? extends BGARecyclerViewAdapter<M>> classOfAdapter;

    private RecyclerView.OnScrollListener onScrollListener;

    private int mLastLoad = -1;
    protected boolean isLoadMore = false;

    private ListUpdateListener listUpdateListener;

    public void setListUpdateListener(ListUpdateListener listUpdateListener) {
        this.listUpdateListener = listUpdateListener;
    }

    private ListItemClickListener listItemClickListener;

    public void setListItemClickListener(ListItemClickListener listItemClickListener) {
        this.listItemClickListener = listItemClickListener;
    }

    private ListItemCheckedListener listItemCheckedListener;

    public void setListItemCheckedListener(ListItemCheckedListener listItemCheckedListener) {
        this.listItemCheckedListener = listItemCheckedListener;
    }

    public void setAdapter(Class<? extends BGARecyclerViewAdapter<M>> classOfT) {
        classOfAdapter = classOfT;
    }

    public BGARecyclerViewAdapter<M> getAdapter() {
        if (mAdapter == null) {
            throw new IllegalStateException("you must add fragment first");
        }
        return mAdapter;
    }

    public static <M> EasyListFragment<M> getInstance() {
        EasyListFragment<M> easyListFragment = new EasyListFragment<>();
        Bundle args = new Bundle();
        easyListFragment.setArguments(args);
        return easyListFragment;
    }

    public EasyListFragment() {
        // Required empty public constructor
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        if (view == null) {
            view = inflater.inflate(R.layout.fragment_easy_list, container, false);
        }

        return view;
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        initView(view);
        // init listener
        initListener();
    }

    private void initView(View view) {
        srl_refresh = (SwipeRefreshLayout) view.findViewById(R.id.srl_refresh);
        rv_list = (RecyclerView) view.findViewById(R.id.rv_list);

        // init view
        srl_refresh.setColorSchemeResources(R.color.colorAccent);

        rv_list.setLayoutManager(new LinearLayoutManager(getContext()));

        //try to get adapter instance by class
        //noinspection TryWithIdenticalCatches
        try {
            //noinspection unchecked
            Constructor<? extends BGARecyclerViewAdapter<M>> constructor = classOfAdapter.getConstructor(RecyclerView.class);
            //noinspection unchecked
            mAdapter = constructor.newInstance(rv_list);
        } catch (java.lang.InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new IllegalStateException("please make sure that your adapter constructor just has one parameter");
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }

        if (mAdapter != null) {
            rv_list.setAdapter(mAdapter);
            mAdapter.setOnItemChildClickListener(new BGAOnItemChildClickListener() {
                @Override
                public void onItemChildClick(ViewGroup parent, View childView, int position) {
                    if (listItemClickListener != null) {
                        listItemClickListener.onClick(parent, childView, position);
                    }
                }
            });
            mAdapter.setOnItemChildCheckedChangeListener(new BGAOnItemChildCheckedChangeListener() {
                @Override
                public void onItemChildCheckedChanged(ViewGroup parent, CompoundButton childView, int position, boolean isChecked) {
                    if (listItemCheckedListener != null) {
                        listItemCheckedListener.onCheckedChanged(parent, childView, position, isChecked);
                    }
                }
            });
        } else {
            throw new IllegalStateException("please call setAdapter before use AbsBaseListFragment");
        }


    }

    private void initListener() {
        // refresh
        srl_refresh.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
            @Override
            public void onRefresh() {
                if (listUpdateListener != null) {
                    mLastLoad = -1;
                    isLoadMore = false;
                    listUpdateListener.onRefresh();
                }
            }
        });

        // 滚动监听
        onScrollListener = new RecyclerView.OnScrollListener() {

            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                int mItemCount;
                int mLastCompletely;


                if (recyclerView.getLayoutManager() instanceof LinearLayoutManager) {
                    LinearLayoutManager mLayoutManager = (LinearLayoutManager) recyclerView.getLayoutManager();

                    mItemCount = mLayoutManager.getItemCount();
                    mLastCompletely = mLayoutManager.findLastVisibleItemPosition();
                } else {
                    return;
                }
                /**
                 * 加载更多判断
                 * 滚动到倒数第1条开始加载
                 */
                if (!isLoadMore && mLastLoad != mItemCount
                        && mItemCount - 3 <= mLastCompletely) {
                    if (listUpdateListener != null) {
                        isLoadMore = true;
                        mLastLoad = mItemCount;
                        listUpdateListener.onLoadMore();
                    }
                }
            }

            @Override
            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                int mFirstCompletely;

                if (recyclerView.getLayoutManager() instanceof LinearLayoutManager) {
                    LinearLayoutManager mLayoutManager = (LinearLayoutManager) recyclerView.getLayoutManager();

                    mFirstCompletely = mLayoutManager.findFirstCompletelyVisibleItemPosition();
                } else {
                    return;
                }
                //刷新判断
                if (mFirstCompletely == 0) {
                    srl_refresh.setEnabled(true);
                } else {
                    srl_refresh.setEnabled(false);
                }
            }
        };

        rv_list.addOnScrollListener(onScrollListener);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();

        if (rv_list != null && onScrollListener != null) {
            rv_list.removeOnScrollListener(onScrollListener);
        }
    }

    public void setRefreshFinished() {
        if (srl_refresh.isRefreshing()) {
            srl_refresh.setRefreshing(false);
        }
    }

    public void setLoadMoreFinished() {
        isLoadMore = false;
    }
}
