/*
 * Decompiled with CFR 0.152.
 */
package io.payworks.labs.tcpmocker.support;

import com.google.common.collect.ImmutableMap;
import io.payworks.labs.tcpmocker.datahandler.DataHandler;
import io.payworks.labs.tcpmocker.datahandler.DataHandlerType;
import io.payworks.labs.tcpmocker.datahandler.DynamicHexRegexDataHandler;
import io.payworks.labs.tcpmocker.datahandler.OrderedDataHandler;
import io.payworks.labs.tcpmocker.datahandler.StaticHexRegexDataHandler;
import io.payworks.labs.tcpmocker.support.DataHandlersLoader;
import io.payworks.labs.tcpmocker.support.DataHandlersLoaderException;
import io.payworks.labs.tcpmocker.support.datahandlermodel.DataHandlerModel;
import io.payworks.labs.tcpmocker.support.datahandlermodel.DataHandlerModelReader;
import io.payworks.labs.tcpmocker.support.json.JsonMappingReader;
import io.payworks.labs.tcpmocker.support.resource.DefaultResourceLoader;
import io.payworks.labs.tcpmocker.support.resource.ResourceLoader;
import io.payworks.labs.tcpmocker.support.yml.YamlMappingReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class DefaultDataHandlersLoader
implements DataHandlersLoader {
    public static final ImmutableMap<Pattern, DataHandlerModelReader> DEFAULT_READERS_MAP = ImmutableMap.of((Object)Pattern.compile(".+\\.json"), (Object)new JsonMappingReader(), (Object)Pattern.compile(".+\\.ya?ml"), (Object)new YamlMappingReader());
    public static final String DEFAULT_MAPPINGS_PATH = "classpath:/tcp-mappings/";
    private final ResourceLoader resourceLoader;
    private String mappingsPath = "classpath:/tcp-mappings/";
    private Map<Pattern, DataHandlerModelReader> readersMap = DEFAULT_READERS_MAP;

    public DefaultDataHandlersLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public DefaultDataHandlersLoader() {
        this(new DefaultResourceLoader());
    }

    public void setMappingsPath(String mappingsPath) {
        this.mappingsPath = mappingsPath;
    }

    public void setReadersMap(Map<Pattern, DataHandlerModelReader> readersMap) {
        this.readersMap = ImmutableMap.copyOf(readersMap);
    }

    public Map<String, OrderedDataHandler> dataHandlers(Set<String> filter) {
        List<String> dirList = this.resourceLoader.list(this.mappingsPath);
        LinkedHashMap dataHandlers = new LinkedHashMap();
        this.readersMap.forEach((pattern, reader) -> {
            Predicate<String> patternPredicate = pattern.asPredicate();
            List filePaths = dirList.stream().filter(filePath -> !filter.contains(filePath) && patternPredicate.test((String)filePath)).collect(Collectors.toList());
            for (String filePath2 : filePaths) {
                try {
                    InputStream inputStream = this.resourceLoader.getInputStream(filePath2);
                    Throwable throwable = null;
                    try {
                        DataHandlerModel dataHandlerModel = reader.read(inputStream);
                        dataHandlers.put(filePath2, this.createOrderedDataHandler(dataHandlerModel));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    throw new DataHandlersLoaderException(e);
                }
            }
        });
        return Collections.unmodifiableMap(dataHandlers);
    }

    private OrderedDataHandler createOrderedDataHandler(DataHandlerModel dataHandlerModel) {
        DataHandler dataHandler = this.createDataHandler(dataHandlerModel);
        int order = this.getOrder(dataHandlerModel);
        return new OrderedDataHandler(order, dataHandler);
    }

    private DataHandler createDataHandler(DataHandlerModel dataHandlerModel) {
        DataHandlerType dataHandlerType = this.getDataHandlerType(dataHandlerModel);
        String hexRegex = dataHandlerModel.getRequest().getMatches();
        String responseData = dataHandlerModel.getResponse().getData();
        switch (dataHandlerType) {
            case DYNAMIC_HEX_REGEX: {
                return new DynamicHexRegexDataHandler(hexRegex, responseData);
            }
            case STATIC_HEX_REGEX: {
                return new StaticHexRegexDataHandler(hexRegex, responseData);
            }
        }
        throw new UnsupportedOperationException(String.format("Unknown DataHandler Type: %s", dataHandlerType));
    }

    private int getOrder(DataHandlerModel dataHandlerModel) {
        Integer order = dataHandlerModel.getOrder();
        return order == null ? 0 : order;
    }

    private DataHandlerType getDataHandlerType(DataHandlerModel dataHandlerModel) {
        DataHandlerType handlerType = dataHandlerModel.getHandlerType();
        return handlerType == null ? DataHandlerType.STATIC_HEX_REGEX : handlerType;
    }
}

