/*
 * Decompiled with CFR 0.152.
 */
package io.payworks.labs.tcpmocker.support;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.payworks.labs.tcpmocker.datahandler.DataHandler;
import io.payworks.labs.tcpmocker.support.DataHandlersLoader;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompositeDataHandlersLoader
implements DataHandlersLoader {
    private final List<DataHandlersLoader> delegateList;

    public CompositeDataHandlersLoader(List<DataHandlersLoader> delegateList) {
        this.delegateList = delegateList;
    }

    @Override
    public Map<String, ? extends DataHandler> dataHandlers(Set<String> filter) {
        ImmutableSet.Builder filterBuilder = ImmutableSet.builder().addAll(filter);
        ImmutableMap.Builder dataHandlers = ImmutableMap.builder();
        for (DataHandlersLoader delegate : this.delegateList) {
            dataHandlers.putAll(delegate.dataHandlers((Set<String>)filterBuilder.build()));
            filterBuilder.addAll((Iterable)dataHandlers.build().keySet());
        }
        return dataHandlers.build();
    }
}

