/*
 * Decompiled with CFR 0.152.
 */
package io.payworks.labs.tcpmocker.support.datahandlermodel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.payworks.labs.tcpmocker.datahandler.DataHandlerType;
import java.util.List;
import java.util.Objects;

public class DataHandlerModel {
    private DataHandlerType handlerType;
    private Integer order;
    private Request request;
    private Response response;

    @JsonCreator
    public DataHandlerModel(@JsonProperty(value="handlerType") DataHandlerType handlerType, @JsonProperty(value="order") Integer order, @JsonProperty(value="request") Request request, @JsonProperty(value="response") Response response) {
        this.handlerType = handlerType;
        this.order = order;
        this.request = request;
        this.response = response;
    }

    @JsonProperty(value="handlerType")
    public DataHandlerType getHandlerType() {
        return this.handlerType;
    }

    @JsonProperty(value="order")
    public Integer getOrder() {
        return this.order;
    }

    @JsonProperty(value="request")
    public Request getRequest() {
        return this.request;
    }

    @JsonProperty(value="response")
    public Response getResponse() {
        return this.response;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataHandlerModel that = (DataHandlerModel)o;
        return this.handlerType == that.handlerType && Objects.equals(this.order, that.order) && Objects.equals(this.request, that.request) && Objects.equals(this.response, that.response);
    }

    public int hashCode() {
        return Objects.hash(this.handlerType, this.order, this.request, this.response);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("handlerType", (Object)this.handlerType).add("order", (Object)this.order).add("request", (Object)this.request).add("response", (Object)this.response).toString();
    }

    public static final class Response {
        private List<String> dataList;

        @JsonCreator
        public Response(@JsonProperty(value="data") List<String> dataList) {
            this.dataList = dataList;
        }

        @JsonProperty(value="data")
        public List<String> getDataList() {
            return ImmutableList.copyOf(this.dataList);
        }

        @JsonIgnore
        public String getData() {
            return String.join((CharSequence)"", this.dataList);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return Objects.equals(this.dataList, response.dataList);
        }

        public int hashCode() {
            return Objects.hash(this.dataList);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("dataList", this.dataList).toString();
        }
    }

    public static final class Request {
        private List<String> matchesList;

        @JsonCreator
        public Request(@JsonProperty(value="matches") List<String> matchesList) {
            this.matchesList = matchesList;
        }

        @JsonProperty(value="matches")
        public List<String> getMatchesList() {
            return ImmutableList.copyOf(this.matchesList);
        }

        @JsonIgnore
        public String getMatches() {
            return String.join((CharSequence)"", this.matchesList);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.matchesList, request.matchesList);
        }

        public int hashCode() {
            return Objects.hash(this.matchesList);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("matchesList", this.matchesList).toString();
        }
    }
}

