/*
 * Decompiled with CFR 0.152.
 */
package io.payworks.labs.tcpmocker.support;

import io.payworks.labs.tcpmocker.TcpServer;
import io.payworks.labs.tcpmocker.TcpServerBuilder;
import io.payworks.labs.tcpmocker.datahandler.DataHandler;
import io.payworks.labs.tcpmocker.support.DataHandlersLoader;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TcpServerFactory {
    private static final Logger logger = LoggerFactory.getLogger(TcpServerFactory.class);
    private final TcpServerBuilder<? extends TcpServer> serverBuilder;
    private final DataHandlersLoader dataHandlersLoader;

    public TcpServerFactory(TcpServerBuilder<? extends TcpServer> serverBuilder, DataHandlersLoader dataHandlersLoader) {
        this.serverBuilder = serverBuilder;
        this.dataHandlersLoader = dataHandlersLoader;
    }

    public TcpServer createTcpServer(int port) {
        Map<String, ? extends DataHandler> dataHandlersMap = this.dataHandlersLoader.dataHandlers();
        String dataHandlersList = dataHandlersMap.keySet().stream().map(key -> String.format("\t- %s", key)).collect(Collectors.joining("\n"));
        if (dataHandlersMap.isEmpty()) {
            logger.warn("No Data Handlers!");
        } else {
            logger.info("Data Handlers ({}):\n{}", (Object)dataHandlersMap.size(), (Object)dataHandlersList);
        }
        this.serverBuilder.withDataHandlers(dataHandlersMap.values());
        this.serverBuilder.withPort(port);
        TcpServer server = this.serverBuilder.build();
        logger.info("Server Started (:{})", (Object)server.getPort());
        return server;
    }
}

