/*
 * Decompiled with CFR 0.152.
 */
package io.payworks.labs.tcpmocker.support.json;

import io.payworks.labs.tcpmocker.support.datahandlermodel.DataHandlerModel;
import io.payworks.labs.tcpmocker.support.json.JsonMappingReader;
import io.payworks.labs.tcpmocker.support.resource.ResourceUtils;
import io.payworks.labs.tcpmocker.test.TcpMappingsRegistry;
import java.net.URL;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class JsonMappingReaderTest {
    private static final URL TEST_DEFAULT_JSON_MAPPING_1_URL = ResourceUtils.toResourceUrl((String)TcpMappingsRegistry.TEST_DEFAULT_JSON_MAPPING_1);
    private static final URL TEST_LIST_JSON_MAPPING_1_URL = ResourceUtils.toResourceUrl((String)TcpMappingsRegistry.TEST_LIST_JSON_MAPPING_1);
    private final JsonMappingReader mappingReader = new JsonMappingReader();

    @Test
    public void readTestDefaultJsonMapping() {
        DataHandlerModel dataHandlerModel = this.mappingReader.read(TEST_DEFAULT_JSON_MAPPING_1_URL);
        MatcherAssert.assertThat((Object)dataHandlerModel, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)dataHandlerModel.getRequest().getMatches(), (Matcher)Matchers.equalToIgnoringCase((String)"0200\\d{10}4F2F0F90000030"));
        MatcherAssert.assertThat((Object)dataHandlerModel.getResponse().getData(), (Matcher)Matchers.equalToIgnoringCase((String)"ad122e1b75356c6fdf3e9c3076a80da6"));
    }

    @Test
    public void readTestListJsonMapping() {
        DataHandlerModel dataHandlerModel = this.mappingReader.read(TEST_LIST_JSON_MAPPING_1_URL);
        MatcherAssert.assertThat((Object)dataHandlerModel, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)dataHandlerModel.getRequest().getMatches(), (Matcher)Matchers.equalToIgnoringCase((String)"0200\\d{10}4F2F0F90000030"));
        MatcherAssert.assertThat((Object)dataHandlerModel.getResponse().getData(), (Matcher)Matchers.equalToIgnoringCase((String)"ad122e1b75356c6fdf3e9c3076a80da6"));
    }
}

