/*
 * Decompiled with CFR 0.152.
 */
package io.payworks.labs.tcpmocker.support;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.spotify.hamcrest.optional.OptionalMatchers;
import io.payworks.labs.tcpmocker.datahandler.DataHandler;
import io.payworks.labs.tcpmocker.support.DefaultDataHandlersLoader;
import io.payworks.labs.tcpmocker.support.datahandlermodel.DataHandlerModelReader;
import io.payworks.labs.tcpmocker.support.json.JsonMappingReader;
import io.payworks.labs.tcpmocker.test.TcpMappingsRegistry;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DefaultDataHandlersLoaderTest {
    private static final byte[] REQUEST_TEST_DATA = BaseEncoding.base16().decode((CharSequence)"020012345678904F2F0F90000030");

    @DataProvider
    public Object[][] testJsonMappings() {
        return new Object[][]{{TcpMappingsRegistry.TEST_DEFAULT_JSON_MAPPING_1, "ad122e1b75356c6fdf3e9c3076a80da6"}, {TcpMappingsRegistry.TEST_DYNAMIC_JSON_MAPPING_1, "020012345678904F2F0F90000030"}, {TcpMappingsRegistry.TEST_DYNAMIC_JSON_MAPPING_2, "123456789042FA0000"}};
    }

    @Test(dataProvider="testJsonMappings")
    public void testDataHandlerLoading(String filePath, String expectedResponseDataPrefix) {
        DefaultDataHandlersLoaderTest.testDataHandlerLoading((DataHandlerModelReader)new JsonMappingReader(), filePath, expectedResponseDataPrefix);
    }

    private static void testDataHandlerLoading(DataHandlerModelReader dataHandlerModelReader, String filePath, String expectedResponseDataPrefix) {
        DataHandler dataHandler = DefaultDataHandlersLoaderTest.loadDataHandler(dataHandlerModelReader, filePath);
        Optional handleResult = dataHandler.handle(REQUEST_TEST_DATA);
        MatcherAssert.assertThat(handleResult.map(arg_0 -> ((BaseEncoding)BaseEncoding.base16()).encode(arg_0)), (Matcher)Matchers.is((Matcher)OptionalMatchers.optionalWithValue((Matcher)Matchers.startsWithIgnoringCase((String)expectedResponseDataPrefix))));
    }

    private static DataHandler loadDataHandler(DataHandlerModelReader dataHandlerModelReader, String filePath) {
        DefaultDataHandlersLoader dataHandlersLoader = new DefaultDataHandlersLoader();
        dataHandlersLoader.setMappingsPath(Paths.get(filePath, new String[0]).getParent().toString());
        dataHandlersLoader.setReadersMap((Map)ImmutableMap.of((Object)Pattern.compile(filePath, 2), (Object)dataHandlerModelReader));
        return (DataHandler)dataHandlersLoader.dataHandlers().get(filePath);
    }
}

