/*
 * Decompiled with CFR 0.152.
 */
package io.payworks.labs.tcpmocker.support.resource;

import io.payworks.labs.tcpmocker.support.resource.ResourceException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;

public final class ResourceUtils {
    private static final String RESOURCE_SCHEME = "classpath:";
    private static final String FILE_SCHEME = "file:";

    private ResourceUtils() {
    }

    public static URL toResourceUrl(Class<?> contextClass, String path) {
        try {
            String resourceName = path.substring(RESOURCE_SCHEME.length());
            ClassLoader context = contextClass == null ? null : contextClass.getClassLoader();
            return IOUtils.resourceToURL((String)resourceName, (ClassLoader)context);
        }
        catch (Exception e) {
            throw ResourceUtils.asResourceException(e);
        }
    }

    public static URL toResourceUrl(String path) {
        return ResourceUtils.toResourceUrl(null, path);
    }

    public static Path toFilePath(String path) {
        return Paths.get(path.substring(FILE_SCHEME.length()), new String[0]);
    }

    public static List<String> listDirectory(String dirPath) {
        if (dirPath.startsWith(RESOURCE_SCHEME)) {
            List<String> list;
            block10: {
                URL resourceUrl = ResourceUtils.toResourceUrl(dirPath);
                InputStream is = resourceUrl.openStream();
                try {
                    List lines = IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    list = lines.stream().map(entry -> ResourceUtils.concat(dirPath, entry)).collect(Collectors.toList());
                    if (is == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw ResourceUtils.asResourceException(e);
                    }
                }
                is.close();
            }
            return list;
        }
        if (dirPath.startsWith(FILE_SCHEME)) {
            Path filePath = ResourceUtils.toFilePath(dirPath);
            return ResourceUtils.listPath(filePath).stream().map(path -> FILE_SCHEME + path).collect(Collectors.toList());
        }
        return ResourceUtils.listPath(Paths.get(dirPath, new String[0]));
    }

    public static byte[] toByteArray(String path) {
        try {
            if (path.startsWith(RESOURCE_SCHEME)) {
                return IOUtils.toByteArray((URL)ResourceUtils.toResourceUrl(path));
            }
            if (path.startsWith(FILE_SCHEME)) {
                return Files.readAllBytes(ResourceUtils.toFilePath(path));
            }
            return Files.readAllBytes(Paths.get(path, new String[0]));
        }
        catch (Exception e) {
            throw ResourceUtils.asResourceException(e);
        }
    }

    public static InputStream getInputStream(String path) {
        try {
            if (path.startsWith(RESOURCE_SCHEME)) {
                return ResourceUtils.toResourceUrl(path).openStream();
            }
            if (path.startsWith(FILE_SCHEME)) {
                return Files.newInputStream(ResourceUtils.toFilePath(path), new OpenOption[0]);
            }
            return Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);
        }
        catch (Exception e) {
            throw ResourceUtils.asResourceException(e);
        }
    }

    public static String concat(String basePath, String path) {
        basePath = basePath.endsWith(ResourceUtils.pathSeparator()) ? basePath.substring(0, basePath.length() - 1) : basePath;
        path = path.startsWith(ResourceUtils.pathSeparator()) ? path.substring(1) : path;
        return basePath + ResourceUtils.pathSeparator() + path;
    }

    private static List<String> listPath(Path dirPath) {
        List<String> list;
        block8: {
            Stream<Path> list2 = Files.list(dirPath);
            try {
                list = list2.map(Path::toString).collect(Collectors.toList());
                if (list2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (list2 != null) {
                        try {
                            list2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw ResourceUtils.asResourceException(e);
                }
            }
            list2.close();
        }
        return list;
    }

    private static String pathSeparator() {
        return "/";
    }

    private static ResourceException asResourceException(Exception e) {
        if (e instanceof ResourceException) {
            return (ResourceException)e;
        }
        return new ResourceException(e);
    }
}

