/*
 * Decompiled with CFR 0.152.
 */
package io.payworks.labs.tcpmocker.support.factory;

import io.payworks.labs.tcpmocker.datahandler.CompositeDataHandler;
import io.payworks.labs.tcpmocker.datahandler.DataHandler;
import io.payworks.labs.tcpmocker.datahandler.DataHandlerType;
import io.payworks.labs.tcpmocker.datahandler.DynamicHexRegexDataHandler;
import io.payworks.labs.tcpmocker.datahandler.HexRegexDataHandler;
import io.payworks.labs.tcpmocker.datahandler.OrderedDataHandler;
import io.payworks.labs.tcpmocker.datahandler.StaticHexRegexDataHandler;
import io.payworks.labs.tcpmocker.support.definition.DataHandlerModel;
import io.payworks.labs.tcpmocker.support.factory.DataHandlerModelFactory;
import java.util.List;
import java.util.stream.Collectors;

public final class DefaultDataHandlerModelFactory
implements DataHandlerModelFactory {
    @Override
    public DataHandler createDataHandler(DataHandlerModel dataHandlerModel) {
        DataHandlerType dataHandlerType = DefaultDataHandlerModelFactory.getDataHandlerType(dataHandlerModel);
        String responseData = dataHandlerModel.getResponse().getData();
        List<DataHandlerModel.Request> requestsToMatch = dataHandlerModel.getRequestList();
        int order = DefaultDataHandlerModelFactory.getOrder(dataHandlerModel);
        List dataHandlers = requestsToMatch.stream().map(DataHandlerModel.Request::getMatches).map(hexRegex -> DefaultDataHandlerModelFactory.createHexRegexDataHandler(dataHandlerType, hexRegex, responseData)).collect(Collectors.toList());
        return new OrderedDataHandler(order, (DataHandler)new CompositeDataHandler(dataHandlers));
    }

    private static HexRegexDataHandler createHexRegexDataHandler(DataHandlerType dataHandlerType, String hexRegex, String responseData) {
        switch (dataHandlerType) {
            case DYNAMIC_HEX_REGEX: {
                return new DynamicHexRegexDataHandler(hexRegex, responseData);
            }
            case STATIC_HEX_REGEX: {
                return new StaticHexRegexDataHandler(hexRegex, responseData);
            }
        }
        throw new UnsupportedOperationException(String.format("Unknown DataHandler Type: %s", dataHandlerType));
    }

    private static int getOrder(DataHandlerModel dataHandlerModel) {
        Integer order = dataHandlerModel.getOrder();
        return order == null ? 0 : order;
    }

    private static DataHandlerType getDataHandlerType(DataHandlerModel dataHandlerModel) {
        DataHandlerType handlerType = dataHandlerModel.getHandlerType();
        return handlerType == null ? DataHandlerType.STATIC_HEX_REGEX : handlerType;
    }
}

