/*
 * Decompiled with CFR 0.152.
 */
package io.payworks.labs.tcpmocker.support.groovy;

import io.payworks.labs.tcpmocker.datahandler.DataHandler;
import io.payworks.labs.tcpmocker.support.definition.DataHandlerProvider;
import io.payworks.labs.tcpmocker.support.factory.DataHandlerFactory;
import io.payworks.labs.tcpmocker.support.groovy.GroovyDataHandlerCompiler;
import io.payworks.labs.tcpmocker.support.groovy.GroovyDataHandlerFactoryException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class GroovyDataHandlerFactory
implements DataHandlerFactory {
    private final GroovyDataHandlerCompiler groovyDataHandlerCompiler;

    public GroovyDataHandlerFactory(GroovyDataHandlerCompiler groovyDataHandlerCompiler) {
        this.groovyDataHandlerCompiler = groovyDataHandlerCompiler;
    }

    public GroovyDataHandlerFactory() {
        this(new GroovyDataHandlerCompiler());
    }

    @Override
    public DataHandler create(InputStream src) {
        try {
            String groovyScript = IOUtils.toString((InputStream)src, (Charset)StandardCharsets.UTF_8);
            DataHandlerProvider dataHandlerProvider = this.groovyDataHandlerCompiler.compile(groovyScript);
            return dataHandlerProvider.getDataHandler();
        }
        catch (IOException e) {
            throw new GroovyDataHandlerFactoryException(e);
        }
    }
}

