/*
 * Decompiled with CFR 0.152.
 */
package io.payworks.labs.tcpmocker.support.builder;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class BinaryMatcherBuilder {
    private static final Charset EBCDIC_1047_CHARSET = Charset.forName("cp1047");
    private final List<byte[]> matchers = new ArrayList<byte[]>();

    public BinaryMatcherBuilder ascii(String str) {
        this.matchers.add(str.getBytes(StandardCharsets.US_ASCII));
        return this;
    }

    public BinaryMatcherBuilder ebcdic(String str) {
        this.matchers.add(str.getBytes(EBCDIC_1047_CHARSET));
        return this;
    }

    public BinaryMatcherBuilder stx() {
        this.matchers.add(new byte[]{2});
        return this;
    }

    public BinaryMatcherBuilder etx() {
        this.matchers.add(new byte[]{3});
        return this;
    }

    public byte[] build() {
        int length = this.matchers.stream().map(arr -> ((byte[])arr).length).reduce(0, Integer::sum);
        byte[] data = new byte[length];
        int destPos = 0;
        for (byte[] matcher : this.matchers) {
            System.arraycopy(matcher, 0, data, destPos, matcher.length);
            destPos += matcher.length;
        }
        return data;
    }
}

