/*
 * Decompiled with CFR 0.152.
 */
package io.payworks.labs.tcpmocker.support;

import com.google.common.collect.ImmutableMap;
import io.payworks.labs.tcpmocker.datahandler.DataHandler;
import io.payworks.labs.tcpmocker.support.DataHandlersLoader;
import io.payworks.labs.tcpmocker.support.DataHandlersLoaderException;
import io.payworks.labs.tcpmocker.support.factory.DataHandlerFactory;
import io.payworks.labs.tcpmocker.support.factory.DefaultDataHandlerModelFactory;
import io.payworks.labs.tcpmocker.support.groovy.GroovyDataHandlerFactory;
import io.payworks.labs.tcpmocker.support.json.JsonDataHandlerFactory;
import io.payworks.labs.tcpmocker.support.resource.DefaultResourceLoader;
import io.payworks.labs.tcpmocker.support.resource.ResourceLoader;
import io.payworks.labs.tcpmocker.support.yml.YamlDataHandlerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class DefaultDataHandlersLoader
implements DataHandlersLoader {
    public static final String DEFAULT_MAPPINGS_PATH = "classpath:/tcp-mappings/";
    private final ResourceLoader resourceLoader;
    private String mappingsPath = "classpath:/tcp-mappings/";
    private Map<Pattern, DataHandlerFactory> dataHandlerFactories;

    public DefaultDataHandlersLoader(ResourceLoader resourceLoader, Map<Pattern, DataHandlerFactory> dataHandlerFactories) {
        this.resourceLoader = resourceLoader;
        this.dataHandlerFactories = Map.copyOf(dataHandlerFactories);
    }

    public DefaultDataHandlersLoader() {
        this(new DefaultResourceLoader(), DefaultDataHandlersLoader.getDefaultDataHandlerFactories());
    }

    public static Map<Pattern, DataHandlerFactory> getDefaultDataHandlerFactories() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (DefaultDataHandlersLoader.classIsPresent("com.fasterxml.jackson.databind.ObjectMapper")) {
            builder.put((Object)Pattern.compile(".+\\.json"), (Object)new JsonDataHandlerFactory(new DefaultDataHandlerModelFactory()));
            if (DefaultDataHandlersLoader.classIsPresent("com.fasterxml.jackson.dataformat.yaml.YAMLFactory")) {
                builder.put((Object)Pattern.compile(".+\\.ya?ml"), (Object)new YamlDataHandlerFactory(new DefaultDataHandlerModelFactory()));
            }
        }
        if (DefaultDataHandlersLoader.classIsPresent("groovy.lang.GroovyShell")) {
            builder.put((Object)Pattern.compile(".+\\.grdh"), (Object)new GroovyDataHandlerFactory());
        }
        return builder.build();
    }

    private static boolean classIsPresent(String className) {
        try {
            Class.forName(className, false, DefaultDataHandlersLoader.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void setMappingsPath(String mappingsPath) {
        this.mappingsPath = mappingsPath;
    }

    public void setDataHandlerFactories(Map<Pattern, DataHandlerFactory> dataHandlerFactories) {
        this.dataHandlerFactories = ImmutableMap.copyOf(dataHandlerFactories);
    }

    public Map<String, DataHandler> dataHandlers(Set<String> filter) {
        List<String> dirList = this.resourceLoader.list(this.mappingsPath);
        LinkedHashMap dataHandlers = new LinkedHashMap();
        dirList.forEach(filePath -> dataHandlers.putAll(this.filePathDataHandlers(filter, (String)filePath)));
        return Collections.unmodifiableMap(dataHandlers);
    }

    private Map<String, DataHandler> filePathDataHandlers(Set<String> filter, String filePath) {
        List patterns = this.dataHandlerFactories.keySet().stream().filter(patternPredicate -> !filter.contains(filePath) && patternPredicate.asPredicate().test(filePath)).collect(Collectors.toList());
        ImmutableMap.Builder dataHandlers = ImmutableMap.builder();
        for (Pattern pattern : patterns) {
            try {
                InputStream inputStream = this.resourceLoader.getInputStream(filePath);
                try {
                    DataHandler dataHandler = this.dataHandlerFactories.get(pattern).create(inputStream);
                    dataHandlers.put((Object)filePath, (Object)dataHandler);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new DataHandlersLoaderException(e);
            }
        }
        return dataHandlers.build();
    }
}

