/*
 * Decompiled with CFR 0.152.
 */
package io.payworks.labs.tcpmocker.support;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.spotify.hamcrest.optional.OptionalMatchers;
import io.payworks.labs.tcpmocker.datahandler.DataHandler;
import io.payworks.labs.tcpmocker.support.DefaultDataHandlersLoader;
import io.payworks.labs.tcpmocker.support.factory.DataHandlerFactory;
import io.payworks.labs.tcpmocker.support.factory.DataHandlerModelFactory;
import io.payworks.labs.tcpmocker.support.factory.DefaultDataHandlerModelFactory;
import io.payworks.labs.tcpmocker.support.json.JsonDataHandlerFactory;
import io.payworks.labs.tcpmocker.support.yml.YamlDataHandlerFactory;
import io.payworks.labs.tcpmocker.test.TcpMappingsRegistry;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DefaultDataHandlersLoaderTest {
    private static final byte[] REQUEST_TEST_DATA_0 = BaseEncoding.base16().decode((CharSequence)"020012345678904F2F0F90000030");
    private static final byte[] REQUEST_TEST_DATA_1 = BaseEncoding.base16().decode((CharSequence)"020112345678904F2F0F90000030");

    @DataProvider
    public Object[][] testJsonMappings() {
        return new Object[][]{{TcpMappingsRegistry.TEST_DEFAULT_JSON_MAPPING_1, "ad122e1b75356c6fdf3e9c3076a80da6"}, {TcpMappingsRegistry.TEST_DYNAMIC_JSON_MAPPING_1, "020012345678904F2F0F90000030"}, {TcpMappingsRegistry.TEST_DYNAMIC_JSON_MAPPING_2, "123456789042FA0000"}};
    }

    @Test(dataProvider="testJsonMappings")
    public void testJsonMappings(String filePath, String expectedResponseData) {
        JsonDataHandlerFactory dataHandlerFactory = new JsonDataHandlerFactory((DataHandlerModelFactory)new DefaultDataHandlerModelFactory());
        DataHandler dataHandler = DefaultDataHandlersLoaderTest.loadDataHandler((DataHandlerFactory)dataHandlerFactory, filePath);
        Optional handleResult = dataHandler.handle(REQUEST_TEST_DATA_0);
        MatcherAssert.assertThat(handleResult.map(arg_0 -> ((BaseEncoding)BaseEncoding.base16()).encode(arg_0)), (Matcher)Matchers.is((Matcher)OptionalMatchers.optionalWithValue((Matcher)Matchers.startsWithIgnoringCase((String)expectedResponseData))));
    }

    @DataProvider
    public Object[][] testMultiRequestMappings() {
        return new Object[][]{{TcpMappingsRegistry.TEST_MULTIREQUEST_JSON_MAPPING_1, new JsonDataHandlerFactory((DataHandlerModelFactory)new DefaultDataHandlerModelFactory()), "ad122e1b75356c6fdf3e9c3076a80da611"}, {TcpMappingsRegistry.TEST_MULTIREQUEST_YAML_MAPPING_1, new YamlDataHandlerFactory((DataHandlerModelFactory)new DefaultDataHandlerModelFactory()), "ad122e1b75356c6fdf3e9c3076a80da612"}};
    }

    @Test(dataProvider="testMultiRequestMappings")
    public void testMultiRequestMappings(String filePath, DataHandlerFactory reader, String expectedResponseData) {
        DataHandler dataHandler = DefaultDataHandlersLoaderTest.loadDataHandler(reader, filePath);
        Optional handleResult1 = dataHandler.handle(REQUEST_TEST_DATA_0);
        Optional handleResult2 = dataHandler.handle(REQUEST_TEST_DATA_1);
        MatcherAssert.assertThat(handleResult1.map(arg_0 -> ((BaseEncoding)BaseEncoding.base16()).encode(arg_0)), (Matcher)Matchers.is((Matcher)OptionalMatchers.optionalWithValue((Matcher)Matchers.startsWithIgnoringCase((String)expectedResponseData))));
        MatcherAssert.assertThat(handleResult2.map(arg_0 -> ((BaseEncoding)BaseEncoding.base16()).encode(arg_0)), (Matcher)Matchers.is((Matcher)OptionalMatchers.optionalWithValue((Matcher)Matchers.startsWithIgnoringCase((String)expectedResponseData))));
    }

    private static DataHandler loadDataHandler(DataHandlerFactory dataHandlerFactory, String filePath) {
        DefaultDataHandlersLoader dataHandlersLoader = new DefaultDataHandlersLoader();
        dataHandlersLoader.setMappingsPath(Paths.get(filePath, new String[0]).getParent().toString());
        dataHandlersLoader.setDataHandlerFactories((Map)ImmutableMap.of((Object)Pattern.compile(filePath, 2), (Object)dataHandlerFactory));
        return (DataHandler)dataHandlersLoader.dataHandlers().get(filePath);
    }
}

