/*
 * Decompiled with CFR 0.152.
 */
package io.payworks.labs.tcpmocker.support.definition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.payworks.labs.tcpmocker.datahandler.DataHandlerType;
import java.util.List;
import java.util.Objects;

public class DataHandlerModel {
    private DataHandlerType handlerType;
    private Integer order;
    private List<Request> requestList;
    private Response response;

    @JsonCreator
    public DataHandlerModel(@JsonProperty(value="handlerType") DataHandlerType handlerType, @JsonProperty(value="order") Integer order, @JsonProperty(value="request") List<Request> requestList, @JsonProperty(value="response") Response response) {
        this.handlerType = handlerType;
        this.order = order;
        this.requestList = requestList;
        this.response = response;
    }

    @JsonProperty(value="handlerType")
    public DataHandlerType getHandlerType() {
        return this.handlerType;
    }

    @JsonProperty(value="order")
    public Integer getOrder() {
        return this.order;
    }

    @JsonProperty(value="request")
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    public List<Request> getRequestList() {
        return ImmutableList.copyOf(this.requestList);
    }

    @JsonIgnore
    public Request getRequest() {
        return (Request)Iterables.getFirst(this.requestList, null);
    }

    @JsonProperty(value="response")
    public Response getResponse() {
        return this.response;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataHandlerModel that = (DataHandlerModel)o;
        return this.handlerType == that.handlerType && Objects.equals(this.order, that.order) && Objects.equals(this.requestList, that.requestList) && Objects.equals(this.response, that.response);
    }

    public int hashCode() {
        return Objects.hash(this.handlerType, this.order, this.requestList, this.response);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("handlerType", (Object)this.handlerType).add("order", (Object)this.order).add("requestList", this.requestList).add("response", (Object)this.response).toString();
    }

    public static final class Response {
        private List<String> dataList;

        @JsonCreator
        public Response(@JsonProperty(value="data") List<String> dataList) {
            this.dataList = dataList;
        }

        @JsonProperty(value="data")
        @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
        public List<String> getDataList() {
            return ImmutableList.copyOf(this.dataList);
        }

        @JsonIgnore
        public String getData() {
            return String.join((CharSequence)"", this.dataList);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return Objects.equals(this.dataList, response.dataList);
        }

        public int hashCode() {
            return Objects.hash(this.dataList);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("dataList", this.dataList).toString();
        }
    }

    public static final class Request {
        private List<String> matchesList;

        @JsonCreator
        public Request(@JsonProperty(value="matches") List<String> matchesList) {
            this.matchesList = matchesList;
        }

        @JsonProperty(value="matches")
        @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
        public List<String> getMatchesList() {
            return ImmutableList.copyOf(this.matchesList);
        }

        @JsonIgnore
        public String getMatches() {
            return String.join((CharSequence)"", this.matchesList);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.matchesList, request.matchesList);
        }

        public int hashCode() {
            return Objects.hash(this.matchesList);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("matchesList", this.matchesList).toString();
        }
    }
}

