/*
 * Decompiled with CFR 0.152.
 */
package io.payworks.labs.tcpmocker.support.yml;

import io.payworks.labs.tcpmocker.datahandler.DataHandler;
import io.payworks.labs.tcpmocker.support.definition.DataHandlerModel;
import io.payworks.labs.tcpmocker.support.factory.DataHandlerModelFactory;
import io.payworks.labs.tcpmocker.support.resource.ResourceUtils;
import io.payworks.labs.tcpmocker.support.yml.YamlDataHandlerFactory;
import io.payworks.labs.tcpmocker.test.TcpMappingsRegistry;
import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class YamlDataHandlerFactoryTest {
    @Mock
    private DataHandlerModelFactory dataHandlerModelFactory;
    @InjectMocks
    private YamlDataHandlerFactory yamlDataHandlerFactory;

    @BeforeMethod
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @AfterMethod
    public void tearDown() {
        this.yamlDataHandlerFactory = null;
    }

    @Test
    public void testCreateYamlDataHandler() {
        InputStream inputStream = ResourceUtils.getInputStream((String)TcpMappingsRegistry.TEST_DEFAULT_YAML_MAPPING_1);
        DataHandler expectedDataHandler = (DataHandler)Mockito.mock(DataHandler.class);
        BDDMockito.given((Object)this.dataHandlerModelFactory.createDataHandler((DataHandlerModel)ArgumentMatchers.any())).willReturn((Object)expectedDataHandler);
        DataHandler dataHandlerModel = this.yamlDataHandlerFactory.create(inputStream);
        MatcherAssert.assertThat((Object)dataHandlerModel, (Matcher)Matchers.equalTo((Object)expectedDataHandler));
        ((DataHandlerModelFactory)Mockito.verify((Object)this.dataHandlerModelFactory)).createDataHandler((DataHandlerModel)ArgumentMatchers.any());
    }
}

