/*
 * Decompiled with CFR 0.152.
 */
package io.payworks.labs.tcpmocker.support.json;

import io.payworks.labs.tcpmocker.support.definition.DataHandlerModel;
import io.payworks.labs.tcpmocker.support.json.JsonDataHandlerModelReader;
import io.payworks.labs.tcpmocker.support.resource.ResourceUtils;
import io.payworks.labs.tcpmocker.test.TcpMappingsRegistry;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class JsonDataHandlerModelReaderTest {
    private final JsonDataHandlerModelReader modelReader = new JsonDataHandlerModelReader();

    @Test
    public void readTestDefaultJsonMapping() {
        DataHandlerModel dataHandlerModel = this.modelReader.readDataHandlerModel(ResourceUtils.getInputStream((String)TcpMappingsRegistry.TEST_DEFAULT_JSON_MAPPING_1));
        MatcherAssert.assertThat((Object)dataHandlerModel, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)dataHandlerModel.getRequest().getMatches(), (Matcher)Matchers.equalToIgnoringCase((String)"0200\\d{10}4F2F0F90000030"));
        MatcherAssert.assertThat((Object)dataHandlerModel.getResponse().getData(), (Matcher)Matchers.equalToIgnoringCase((String)"ad122e1b75356c6fdf3e9c3076a80da6"));
    }

    @Test
    public void readTestListJsonMapping() {
        DataHandlerModel dataHandlerModel = this.modelReader.readDataHandlerModel(ResourceUtils.getInputStream((String)TcpMappingsRegistry.TEST_LIST_JSON_MAPPING_1));
        MatcherAssert.assertThat((Object)dataHandlerModel, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)dataHandlerModel.getRequest().getMatches(), (Matcher)Matchers.equalToIgnoringCase((String)"0200\\d{10}4F2F0F90000030"));
        MatcherAssert.assertThat((Object)dataHandlerModel.getResponse().getData(), (Matcher)Matchers.equalToIgnoringCase((String)"ad122e1b75356c6fdf3e9c3076a80da6"));
    }

    @Test
    public void readTestMultiRequestJsonMapping() {
        DataHandlerModel dataHandlerModel = this.modelReader.readDataHandlerModel(ResourceUtils.getInputStream((String)TcpMappingsRegistry.TEST_MULTIREQUEST_JSON_MAPPING_1));
        MatcherAssert.assertThat((Object)dataHandlerModel, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat(dataHandlerModel.getRequestList().stream().map(DataHandlerModel.Request::getMatches).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{"0200\\d{10}4F2F0F90000030", "0201\\d{10}4F2F0F90000030"}));
        MatcherAssert.assertThat((Object)dataHandlerModel.getResponse().getData(), (Matcher)Matchers.equalToIgnoringCase((String)"ad122e1b75356c6fdf3e9c3076a80da611"));
    }
}

