/*
 * Decompiled with CFR 0.152.
 */
package io.payworks.labs.tcpmocker;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.payworks.labs.tcpmocker.DispatchingDataHandlerServerBuilder;
import io.payworks.labs.tcpmocker.NettyDataHandlerAdapter;
import io.payworks.labs.tcpmocker.NettyTcpServer;
import io.payworks.labs.tcpmocker.TcpServerException;
import java.util.concurrent.ThreadFactory;

public class NettyTcpServerBuilder
extends DispatchingDataHandlerServerBuilder<NettyTcpServer, NettyTcpServerBuilder> {
    private final int acceptThreads;
    private final int connectThreads;
    private final int queueSize;

    public NettyTcpServerBuilder(int acceptThreads, int connectThreads, int queueSize) {
        this.acceptThreads = acceptThreads;
        this.connectThreads = connectThreads;
        this.queueSize = queueSize;
    }

    public NettyTcpServerBuilder() {
        this(1, 5, 100);
    }

    public NettyTcpServer build() {
        try {
            return this.createNettyTcpServer();
        }
        catch (Exception e) {
            throw new TcpServerException((Throwable)e);
        }
    }

    private NettyTcpServer createNettyTcpServer() throws Exception {
        DefaultThreadFactory acceptThreadFactory = new DefaultThreadFactory("accept");
        DefaultThreadFactory connectThreadFactory = new DefaultThreadFactory("connect");
        NioEventLoopGroup acceptGroup = new NioEventLoopGroup(this.acceptThreads, (ThreadFactory)acceptThreadFactory);
        NioEventLoopGroup connectGroup = new NioEventLoopGroup(this.connectThreads, (ThreadFactory)connectThreadFactory);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> NettyTcpServerBuilder.lambda$createNettyTcpServer$0((EventLoopGroup)acceptGroup, (EventLoopGroup)connectGroup)));
        ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)acceptGroup, (EventLoopGroup)connectGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)this.queueSize)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new NettyDataHandlerAdapter(NettyTcpServerBuilder.this.createDataHandlerDispatcher())});
            }
        });
        return new NettyTcpServer(bootstrap.bind(this.getPort()));
    }

    protected NettyTcpServerBuilder self() {
        return this;
    }

    private static /* synthetic */ void lambda$createNettyTcpServer$0(EventLoopGroup acceptGroup, EventLoopGroup connectGroup) {
        acceptGroup.shutdownGracefully();
        connectGroup.shutdownGracefully();
    }
}

