/*
 * Decompiled with CFR 0.152.
 */
package io.payworks.labs.tcpmocker;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import io.payworks.labs.tcpmocker.AbstractTcpServer;
import io.payworks.labs.tcpmocker.NettyTcpServerBuilder;
import java.net.InetSocketAddress;

public class NettyTcpServer
extends AbstractTcpServer {
    private final Channel channel;
    private final EventLoopGroup acceptGroup;
    private final EventLoopGroup connectGroup;

    NettyTcpServer(ChannelFuture bindFuture, EventLoopGroup acceptGroup, EventLoopGroup connectGroup) throws Exception {
        super(((InetSocketAddress)bindFuture.sync().channel().localAddress()).getPort());
        this.channel = bindFuture.channel();
        this.acceptGroup = acceptGroup;
        this.connectGroup = connectGroup;
    }

    public void close() {
        try {
            if (this.channel.isOpen()) {
                this.channel.close().sync();
            }
            this.acceptGroup.shutdownGracefully().syncUninterruptibly();
            this.connectGroup.shutdownGracefully().syncUninterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static NettyTcpServerBuilder builder() {
        return new NettyTcpServerBuilder();
    }
}

