/*
 * Decompiled with CFR 0.152.
 */
package io.payworks.labs.tcpmocker;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.payworks.labs.tcpmocker.datahandler.DataHandler;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyDataHandlerAdapter
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(NettyDataHandlerAdapter.class);
    private final DataHandler dataHandler;
    private ByteBuf readBuf;
    private ByteBuf writeBuf;

    NettyDataHandlerAdapter(DataHandler dataHandler) {
        this.dataHandler = dataHandler;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        logger.info("Connection Established");
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        this.bootstrap(ctx);
        if (msg instanceof ByteBuf) {
            this.readMsgToReadBuf((ByteBuf)msg);
            if (this.handleToWriteBuf()) {
                this.flushWriteBuf(ctx);
            }
        } else {
            throw new UnsupportedOperationException(String.format("Unsupported Message: %s", msg.getClass()));
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("Connection Closed", cause);
        ctx.close();
    }

    private void bootstrap(ChannelHandlerContext ctx) {
        if (this.readBuf == null) {
            this.readBuf = ctx.alloc().buffer();
        }
        if (this.writeBuf == null) {
            this.writeBuf = ctx.alloc().buffer();
        }
    }

    private void readMsgToReadBuf(ByteBuf byteBuf) {
        this.readBuf.writeBytes(byteBuf);
        byteBuf.release();
    }

    private boolean handleToWriteBuf() {
        Optional<byte[]> handleResult = this.tryHandle();
        if (handleResult.isEmpty()) {
            return false;
        }
        this.readBuf.release();
        this.readBuf = null;
        this.writeBuf.writeBytes(handleResult.get());
        return true;
    }

    private Optional<byte[]> tryHandle() {
        return this.dataHandler.handle(NettyDataHandlerAdapter.toByteArray(this.readBuf));
    }

    private static byte[] toByteArray(ByteBuf byteBuf) {
        if (byteBuf.hasArray()) {
            return byteBuf.array();
        }
        byte[] data = new byte[byteBuf.readableBytes()];
        byteBuf.getBytes(0, data);
        return data;
    }

    private void flushWriteBuf(ChannelHandlerContext ctx) {
        ByteBuf writeBufRef = this.writeBuf;
        this.writeBuf = null;
        if (writeBufRef.writerIndex() != 0) {
            ctx.write((Object)writeBufRef).addListener(f -> {
                if (!f.isSuccess()) {
                    logger.error("Unexpected Error!", f.cause());
                }
            });
        } else {
            writeBufRef.release();
            ctx.close();
        }
    }
}

