/*
 * Decompiled with CFR 0.152.
 */
package io.payworks.labs.tcpmocker;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.payworks.labs.tcpmocker.datahandler.DataHandler;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyDataHandlerAdapter
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(NettyDataHandlerAdapter.class);
    private final DataHandler dataHandler;
    private ByteBuf readBuf;
    private ByteBuf writeBuf;

    NettyDataHandlerAdapter(DataHandler dataHandler) {
        this.dataHandler = dataHandler;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        logger.info("Connection Established");
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        this.alloc(ctx);
        if (msg instanceof ByteBuf) {
            this.readBytes((ByteBuf)msg);
            if (this.handle()) {
                this.writeBytes(ctx);
            }
        } else {
            throw new UnsupportedOperationException(String.format("Unsupported Message: %s", msg.getClass()));
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("Connection Closed", cause);
        ctx.close();
    }

    private void alloc(ChannelHandlerContext ctx) {
        if (this.readBuf == null) {
            this.readBuf = ctx.alloc().buffer();
        }
        if (this.writeBuf == null) {
            this.writeBuf = ctx.alloc().buffer();
        }
    }

    private void readBytes(ByteBuf byteBuf) {
        this.readBuf.writeBytes(byteBuf);
        byteBuf.release();
    }

    private boolean handle() {
        Optional handleResult = this.dataHandler.handle(NettyDataHandlerAdapter.getBytes(this.readBuf));
        handleResult.ifPresent(bytes -> {
            this.writeBuf.writeBytes(bytes);
            this.readBuf.release();
            this.readBuf = null;
        });
        return handleResult.isPresent();
    }

    private static byte[] getBytes(ByteBuf byteBuf) {
        if (byteBuf.hasArray()) {
            return byteBuf.array();
        }
        byte[] data = new byte[byteBuf.readableBytes()];
        byteBuf.getBytes(0, data);
        return data;
    }

    private void writeBytes(ChannelHandlerContext ctx) {
        if (this.writeBuf.writerIndex() == 0) {
            this.writeBuf = null;
            ctx.close();
        } else {
            ctx.write((Object)this.writeBuf).addListener(f -> {
                if (!f.isSuccess()) {
                    logger.error("Unexpected Error!", f.cause());
                }
            });
            this.writeBuf = null;
        }
    }
}

