/*
 * Decompiled with CFR 0.152.
 */
package io.payworks.labs.tcpmocker.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class PageCollectorTemplate {
    private PageCollectorTemplate() {
    }

    public static <ENTITY> List<ENTITY> collectAllPages(BiFunction<Integer, Integer, List<ENTITY>> pageSupplier, int pageSize) {
        List<ENTITY> page;
        ArrayList<ENTITY> entities = new ArrayList<ENTITY>();
        int pageNumber = 0;
        while (!(page = pageSupplier.apply(pageNumber, pageSize)).isEmpty()) {
            entities.addAll(page);
            ++pageNumber;
        }
        return entities;
    }

    public static <ENTITY, PAGE> List<ENTITY> collectAllPages(Function<PAGE, List<ENTITY>> pageSupplier, BiFunction<Integer, Integer, PAGE> pageableBuilder, int pageSize) {
        List<ENTITY> page;
        ArrayList<ENTITY> entities = new ArrayList<ENTITY>();
        int pageNumber = 0;
        while (!(page = pageSupplier.apply(pageableBuilder.apply(pageNumber, pageSize))).isEmpty()) {
            entities.addAll(page);
            ++pageNumber;
        }
        return entities;
    }
}

