/*
 * Decompiled with CFR 0.152.
 */
package io.payworks.labs.tcpmocker.data;

import com.google.common.io.BaseEncoding;
import java.time.Instant;

public class RecordingData {
    private final Instant timestamp;
    private final String request;
    private final String reply;

    public RecordingData() {
        this.timestamp = null;
        this.request = null;
        this.reply = null;
    }

    private RecordingData(Instant timestamp, String request, String reply) {
        this.timestamp = timestamp;
        this.request = request;
        this.reply = reply;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getRequest() {
        return this.request;
    }

    public String getReply() {
        return this.reply;
    }

    public static Builder create() {
        return new Builder();
    }

    public static final class Builder {
        private Instant timestamp;
        private String request;
        private String reply;

        public Builder withTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder withRequest(byte[] request) {
            this.request = BaseEncoding.base16().encode(request);
            return this;
        }

        public Builder withRequest(String request) {
            this.request = request;
            return this;
        }

        public Builder withReply(byte[] reply) {
            this.reply = BaseEncoding.base16().encode(reply);
            return this;
        }

        public Builder withReply(String reply) {
            this.reply = reply;
            return this;
        }

        public final RecordingData build() {
            return new RecordingData(this.timestamp, this.request, this.reply);
        }
    }
}

