/*
 * Decompiled with CFR 0.152.
 */
package io.payworks.labs.tcpmocker;

import io.payworks.labs.tcpmocker.test.tcpclient.SimpleTcpClient;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testcontainers.containers.DockerComposeContainer;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TcpMockerAppDockerIT {
    private static final String TCP_MOCKER_APP_SERVICE_NAME = "tcp-mocker-app";
    private static final int TCP_SERVICE_PORT = 10001;
    private static final int WEB_SERVICE_PORT = 8080;
    private static final String TCP_MOCKER_APP_CONTAINER_TAG = Optional.ofNullable(System.getenv("PROJECT_VERSION")).orElse("LOCAL-SNAPSHOT");
    private static final DockerComposeContainer tcpMockerContainer = new DockerComposeContainer(new File[]{new File("tcp-mocker-app/docker-compose.yml")}).withExposedService("tcp-mocker-app", 10001).withExposedService("tcp-mocker-app", 8080).withEnv("TCP_MOCKER_APP_TAG", TCP_MOCKER_APP_CONTAINER_TAG).withLocalCompose(true).withPull(false);
    private SimpleTcpClient tcpClient;

    @BeforeClass
    public static void startContainer() {
        tcpMockerContainer.start();
    }

    @AfterClass
    public static void stopContainer() {
        tcpMockerContainer.stop();
    }

    @BeforeMethod
    public void setup() throws Exception {
        this.tcpClient = new SimpleTcpClient(TcpMockerAppDockerIT.getTcpServiceHost(), TcpMockerAppDockerIT.getTcpServicePort().intValue());
    }

    @AfterMethod
    public void close() throws Exception {
        this.tcpClient.close();
    }

    @Test
    public void testContainer() throws Exception {
        String received = new String(this.tcpClient.sendAndReceive("ping".getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)received, (Matcher)Matchers.equalTo((Object)"pong"));
    }

    private static Integer getTcpServicePort() {
        return tcpMockerContainer.getServicePort(TCP_MOCKER_APP_SERVICE_NAME, Integer.valueOf(10001));
    }

    private static String getTcpServiceHost() {
        return tcpMockerContainer.getServiceHost(TCP_MOCKER_APP_SERVICE_NAME, Integer.valueOf(10001));
    }
}

