package io.paulbaker.libs.datastructures

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonProperty

/**
 * Holds a single item
 *
 * @author Paul Nelson Baker
 * @see <a href="https://github.com/paul-nelson-baker/">GitHub</a>
 * @see <a href="https://www.linkedin.com/in/paul-n-baker/">LinkedIn</a>
 * @since 2019-01
 */
data class Monad<T>(val item: T)

/**
 * Holds a single comparable item
 *
 * @author Paul Nelson Baker
 * @see <a href="https://github.com/paul-nelson-baker/">GitHub</a>
 * @see <a href="https://www.linkedin.com/in/paul-n-baker/">LinkedIn</a>
 * @since 2019-01
 */
data class OrdinalMonad<T : Comparable<T>>(val item: T) : Comparable<OrdinalMonad<T>> {
    override fun compareTo(other: OrdinalMonad<T>): Int = compareValuesBy(this, other) { it.item }
}

/**
 * Represents a general yet type-safe way to represent an api key
 *
 * @author Paul Nelson Baker
 * @see <a href="https://github.com/paul-nelson-baker/">GitHub</a>
 * @see <a href="https://www.linkedin.com/in/paul-n-baker/">LinkedIn</a>
 * @since 2019-01
 */
class AccessKeyMonad @JsonCreator constructor(@JsonProperty("key") val key: CharArray) {

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AccessKeyMonad

        if (!key.contentEquals(other.key)) return false

        return true
    }

    override fun hashCode(): Int {
        return key.contentHashCode()
    }
}