/*
 * Copyright 2019 Patriot project
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package io.patriot_framework.network_simulator.docker.network;

import io.patriot_framework.network_simulator.docker.container.DockerContainer;
import io.patriot_framework.network_simulator.docker.manager.DockerManager;

/**
 * The type Docker network utilities.
 */
public class DockerNetworkUtilities {

    /**
     * Sets default gw.
     *
     * @param container the container
     * @param gateway   the gateway
     * @param manager   the manager
     */
    public void setDefaultGw(DockerContainer container, String gateway, DockerManager manager) {
        manager.runCommand(container, "route del default");
        manager.runCommand(container, "route add default gw " + gateway);
    }
}
