/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.plugin.http.clientauth;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import io.parallec.core.config.ParallecGlobalConfig;
import io.parallec.core.util.PcFileNetworkIoUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClientFactoryClientAuth {
    private AsyncHttpClient fastClient;
    private AsyncHttpClient slowClient;
    private AtomicBoolean isClosed = new AtomicBoolean(false);
    private static Logger logger = LoggerFactory.getLogger(HttpClientFactoryClientAuth.class);
    private SSLContext sslContext;

    public void stop() {
        this.fastClient.close();
        this.slowClient.close();
    }

    public HttpClientFactoryClientAuth(String privKeyPasshraseFilePath, String keystoreFilePath, String algorithm, boolean verifyServerCert) {
        AsyncHttpClient fastClient = null;
        AsyncHttpClient slowClient = null;
        try {
            if (!PcFileNetworkIoUtils.isFileExist((String)privKeyPasshraseFilePath)) {
                logger.error("private key pass file does not exist on " + privKeyPasshraseFilePath + ". Cannot load the client auth client. " + "Please prepare the private key pass file and put it in the path and try again.");
                return;
            }
            if (!PcFileNetworkIoUtils.isFileExist((String)keystoreFilePath)) {
                logger.error("keystore file does not exist on " + keystoreFilePath + ". Cannot load the client auth client. " + "Please prepare the keystore file and put it in the path and try again.");
                return;
            }
            this.initCertificateVerification(privKeyPasshraseFilePath, keystoreFilePath, algorithm, verifyServerCert);
            AsyncHttpClientConfig.Builder builderFastClient = new AsyncHttpClientConfig.Builder();
            builderFastClient.setSSLContext(this.sslContext);
            builderFastClient.setConnectionTimeoutInMs(ParallecGlobalConfig.ningFastClientConnectionTimeoutMillis);
            builderFastClient.setRequestTimeoutInMs(ParallecGlobalConfig.ningFastClientRequestTimeoutMillis);
            logger.info("FastClient Client Auth: ningFastClientConnectionTimeoutMillis: {}", (Object)ParallecGlobalConfig.ningFastClientConnectionTimeoutMillis);
            logger.info("FastClient Client Auth: ningFastClientRequestTimeoutMillis: {}", (Object)ParallecGlobalConfig.ningFastClientRequestTimeoutMillis);
            fastClient = new AsyncHttpClient(builderFastClient.build());
            AsyncHttpClientConfig.Builder builderSlowClient = new AsyncHttpClientConfig.Builder();
            builderSlowClient.setSSLContext(this.sslContext);
            builderSlowClient.setConnectionTimeoutInMs(ParallecGlobalConfig.ningSlowClientConnectionTimeoutMillis);
            builderSlowClient.setRequestTimeoutInMs(ParallecGlobalConfig.ningSlowClientRequestTimeoutMillis);
            slowClient = new AsyncHttpClient(builderSlowClient.build());
        }
        catch (Exception e) {
            logger.error("ERROR IN AsyncHttpClientFactorySafe " + e.getLocalizedMessage() + " cause: " + e.getCause());
        }
        this.fastClient = fastClient;
        this.slowClient = slowClient;
    }

    public void closeClients() {
        this.slowClient.close();
        this.fastClient.close();
        this.isClosed.set(true);
    }

    public AsyncHttpClient getFastClient() {
        return this.fastClient;
    }

    public AsyncHttpClient getSlowClient() {
        return this.slowClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initCertificateVerification(String privKeyFilePath, String keystoreFilePath, String algorithm, boolean verifyServerCert) {
        InputStream keyStoreStream = null;
        try {
            String phrase = PcFileNetworkIoUtils.readFileContentToString((String)privKeyFilePath);
            phrase = phrase.trim();
            logger.info("loaded private key pass successfully...");
            keyStoreStream = PcFileNetworkIoUtils.readFileToInputStream((String)keystoreFilePath);
            char[] keyStorePassword = phrase.toCharArray();
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(keyStoreStream, keyStorePassword);
            keyStoreStream.close();
            char[] certificatePassword = phrase.toCharArray();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, certificatePassword);
            KeyManager[] keyManagers = kmf.getKeyManagers();
            SecureRandom secureRandom = new SecureRandom();
            TrustManager[] trustManager = null;
            if (verifyServerCert) {
                TrustManagerFactory trustManagers = TrustManagerFactory.getInstance("SunX509");
                trustManagers.init(ks);
                trustManager = trustManagers.getTrustManagers();
            } else {
                trustManager = new TrustManager[]{new CustomTrustManager()};
            }
            this.sslContext = SSLContext.getInstance(algorithm);
            this.sslContext.init(keyManagers, trustManager, secureRandom);
            HostnameVerifier verifier = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(verifier);
        }
        catch (IOException t) {
            logger.error("fail IO Exception when trying to read the files" + t);
        }
        catch (Throwable t) {
            logger.error("fail" + t);
        }
        finally {
            if (keyStoreStream != null) {
                try {
                    keyStoreStream.close();
                }
                catch (IOException e) {
                    logger.error("io exception", (Throwable)e);
                }
            }
        }
    }

    public static class CustomTrustManager
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

