/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.plugin.http.clientauth;

import io.parallec.core.ParallelClient;
import io.parallec.core.config.ParallecGlobalConfig;
import io.parallec.core.resources.HttpClientType;
import io.parallec.plugin.http.clientauth.HttpClientFactoryClientAuth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientAuthAdaptor {
    private static Logger logger = LoggerFactory.getLogger(ClientAuthAdaptor.class);
    public String privKeyPassPhraseFilePathDefault = ParallecGlobalConfig.userDataFolderWithSlash + "keypass";
    public String keystoreFilePathDefault = ParallecGlobalConfig.userDataFolderWithSlash + "keystore.jks";
    public static String algorithmDefault = "TLS";
    public static boolean verifyServerCertDefault = false;
    private static final ClientAuthAdaptor instance = new ClientAuthAdaptor();
    public HttpClientFactoryClientAuth factory = null;

    public static ClientAuthAdaptor getInstance() {
        return instance;
    }

    private ClientAuthAdaptor() {
    }

    public void enableClientAuth(ParallelClient pc) {
        this.enableClientAuth(pc, this.privKeyPassPhraseFilePathDefault, this.keystoreFilePathDefault, algorithmDefault, verifyServerCertDefault);
    }

    public void enableClientAuth(ParallelClient pc, String algorithm) {
        this.enableClientAuth(pc, this.privKeyPassPhraseFilePathDefault, this.keystoreFilePathDefault, algorithm, verifyServerCertDefault);
    }

    public void enableClientAuth(ParallelClient pc, String privKeyPasshraseFilePath, String keystoreFilePath) {
        this.enableClientAuth(pc, privKeyPasshraseFilePath, keystoreFilePath, algorithmDefault, verifyServerCertDefault);
    }

    public void enableClientAuth(ParallelClient pc, String privKeyPasshraseFilePath, String keystoreFilePath, String algorithm) {
        this.enableClientAuth(pc, privKeyPasshraseFilePath, keystoreFilePath, algorithm, verifyServerCertDefault);
    }

    public void enableClientAuth(ParallelClient pc, String privKeyPasshraseFilePath, String keystoreFilePath, String algorithm, boolean verifyServerCert) {
        if (this.factory != null) {
            logger.debug("factory is already initialized. will NO OP. call reset() to close the current clients and then try again.");
            return;
        }
        this.factory = new HttpClientFactoryClientAuth(privKeyPasshraseFilePath, keystoreFilePath, algorithm, verifyServerCert);
        pc.setCustomClientFast(this.factory.getFastClient());
        pc.setCustomClientSlow(this.factory.getSlowClient());
        pc.setHttpClientTypeCurrentDefault(HttpClientType.CUSTOM_FAST);
    }

    public void shutdown() {
        if (this.factory == null) {
            logger.debug("factory is not initialized. will NO OP. ");
            return;
        }
        this.factory.closeClients();
        this.factory = null;
        logger.info("factory clients have been closed and set as null. ready to init again ");
    }
}

