/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcStringUtils {
    private static Logger logger = LoggerFactory.getLogger(PcStringUtils.class);

    public static String printStackTrace(Throwable t) {
        return t == null ? "NA" : ExceptionUtils.getStackTrace((Throwable)t);
    }

    public static String strMapToStr(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        if (map == null || map.isEmpty()) {
            return sb.toString();
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append("< " + entry.getKey() + ", " + entry.getValue() + "> ");
        }
        return sb.toString();
    }

    public static String getAggregatedResultHuman(Map<String, LinkedHashSet<String>> aggregateResultMap) {
        StringBuilder res = new StringBuilder();
        for (Map.Entry<String, LinkedHashSet<String>> entry : aggregateResultMap.entrySet()) {
            LinkedHashSet<String> valueSet = entry.getValue();
            res.append("[" + entry.getKey() + " COUNT: " + valueSet.size() + " ]:\n");
            for (String str : valueSet) {
                res.append("\t" + str + "\n");
            }
            res.append("###################################\n\n");
        }
        return res.toString();
    }

    public static String renderJson(Object o) {
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
        String jsonOutput = gson.toJson(o);
        return jsonOutput;
    }
}

