/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.util;

import com.ning.http.client.AsyncHttpClient;
import io.parallec.core.actor.message.NodeReqResponse;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcHttpUtils {
    private static Logger logger = LoggerFactory.getLogger(PcHttpUtils.class);

    public static boolean isUrlValid(String url) {
        return !url.trim().contains(" ");
    }

    public static void replaceHttpHeaderMapNodeSpecific(Map<String, String> httpHeaderMap, Map<String, String> requestParameters) {
        boolean needToReplaceVarInHttpHeader = false;
        for (String string : requestParameters.keySet()) {
            if (!string.contains("REPLACE-VAR_")) continue;
            needToReplaceVarInHttpHeader = true;
            break;
        }
        if (!needToReplaceVarInHttpHeader) {
            logger.debug("No need to replace. Since there are no HTTP header variables. ");
            return;
        }
        for (Map.Entry entry : httpHeaderMap.entrySet()) {
            String key = (String)entry.getKey();
            String valueOriginal = (String)entry.getValue();
            String valueUpdated = NodeReqResponse.replaceStrByMap(requestParameters, valueOriginal);
            httpHeaderMap.put(key, valueUpdated);
        }
    }

    public static void addHeaders(AsyncHttpClient.BoundRequestBuilder builder, Map<String, String> headerMap) {
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            builder.addHeader(name, value);
        }
    }
}

