/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.bean.tcp;

import io.parallec.core.config.ParallecGlobalConfig;
import io.parallec.core.exception.ParallelTaskInvalidException;
import io.parallec.core.resources.TcpSshPingResourceStore;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.handler.codec.string.StringDecoder;
import org.jboss.netty.handler.codec.string.StringEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpMeta {
    private static Logger logger = LoggerFactory.getLogger(TcpMeta.class);
    public static final ChannelHandler stringDecoder = new StringDecoder();
    public static final ChannelHandler stringEncoder = new StringEncoder();
    private String command;
    private Integer tcpPort;
    private Integer tcpConnectTimeoutMillis;
    private Integer tcpIdleTimeoutSec;
    private ChannelFactory channelFactory;

    public TcpMeta(String command, int tcpPort, int tcpConnectTimeoutMillis, int tcpIdleTimeoutSec, ChannelFactory channelFactory) {
        this.command = command;
        this.tcpPort = tcpPort;
        this.tcpConnectTimeoutMillis = tcpConnectTimeoutMillis;
        this.tcpIdleTimeoutSec = tcpIdleTimeoutSec;
        this.channelFactory = channelFactory;
    }

    public TcpMeta() {
        this.command = null;
        this.tcpPort = null;
        this.channelFactory = null;
        this.tcpConnectTimeoutMillis = null;
        this.tcpIdleTimeoutSec = null;
    }

    public boolean validation() throws ParallelTaskInvalidException {
        if (this.command == null) {
            throw new ParallelTaskInvalidException("command is null for TCP");
        }
        if (this.tcpPort == null) {
            throw new ParallelTaskInvalidException("tcpPort is null. please set");
        }
        if (this.tcpConnectTimeoutMillis == null) {
            logger.info("SET DEFAULT TCP CONNECT TIMEOUT: TCP tcpConnectTimeoutMillis is set as default");
            this.tcpConnectTimeoutMillis = ParallecGlobalConfig.tcpConnectTimeoutMillisDefault;
        }
        if (this.tcpIdleTimeoutSec == null) {
            logger.info("SET DEFAULT TCP IDLE TIMEOUT: TCP tcpIdleTimeoutSec is set as default");
            this.tcpIdleTimeoutSec = ParallecGlobalConfig.tcpIdleTimeoutSecDefault;
        }
        if (this.channelFactory == null) {
            logger.info("SET DEFAULT TCP NETTY CHANNEL FACTORY: TCP channelFactory is set as default");
            this.channelFactory = TcpSshPingResourceStore.getInstance().getChannelFactory();
        }
        return true;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public void setTcpPort(int tcpPort) {
        this.tcpPort = tcpPort;
    }

    public int getTcpConnectTimeoutMillis() {
        return this.tcpConnectTimeoutMillis;
    }

    public void setTcpConnectTimeoutMillis(int tcpConnectTimeoutMillis) {
        this.tcpConnectTimeoutMillis = tcpConnectTimeoutMillis;
    }

    public ChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    public void setChannelFactory(ChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
    }

    public Integer getTcpIdleTimeoutSec() {
        return this.tcpIdleTimeoutSec;
    }

    public void setTcpIdleTimeoutSec(Integer tcpIdleTimeoutSec) {
        this.tcpIdleTimeoutSec = tcpIdleTimeoutSec;
    }
}

