/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.bean;

import com.ning.http.client.AsyncHttpClient;
import io.parallec.core.ParallecHeader;
import io.parallec.core.actor.poll.HttpPollerProcessor;
import io.parallec.core.exception.ParallelTaskInvalidException;
import io.parallec.core.resources.HttpClientStore;
import io.parallec.core.resources.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMeta {
    private static Logger logger = LoggerFactory.getLogger(HttpMeta.class);
    private HttpMethod httpMethod;
    private String requestUrlPostfix;
    private String entityBody;
    private String requestPort;
    private ParallecHeader parallecHeader;
    private HttpPollerProcessor httpPollerProcessor = null;
    private boolean isPollable = false;
    private AsyncHttpClient asyncHttpClient;

    public HttpMeta() {
        this.httpMethod = null;
        this.requestUrlPostfix = null;
        this.entityBody = null;
        this.requestPort = null;
        this.parallecHeader = null;
        this.httpPollerProcessor = null;
        this.isPollable = false;
        this.asyncHttpClient = null;
    }

    public void initValuesNa() {
        this.setRequestPort("0");
        this.setHeaderMetadata(new ParallecHeader());
        this.setHttpMethod(HttpMethod.NA);
        this.setEntityBody("$PARALLEC_EMPTY_REQUEST_BODY");
        this.setRequestUrlPostfix("");
        this.httpPollerProcessor = null;
        this.isPollable = false;
        this.asyncHttpClient = null;
    }

    public boolean validation() throws ParallelTaskInvalidException {
        if (this.getAsyncHttpClient() == null) {
            logger.info("USE DEFAULT HTTP CLIENT: Did not set special asyncHttpClient, will use the current default one: " + HttpClientStore.getInstance().getHttpClientTypeCurrentDefault().toString());
            this.asyncHttpClient = HttpClientStore.getInstance().getCurrentDefaultClient();
        }
        if (this.getHttpMethod() == null) {
            throw new ParallelTaskInvalidException("Missing getHttpMethod!");
        }
        if (this.getHeaderMetadata() == null) {
            logger.info("USE DEFAULT EMPTY HEADER: Did not specify HTTP header. Will use empty header. Use .setHeaders to add headers");
            this.setHeaderMetadata(new ParallecHeader());
        }
        if (this.getEntityBody() == null) {
            this.setEntityBody("$PARALLEC_EMPTY_REQUEST_BODY");
        }
        if (this.getRequestPort() == null) {
            this.setRequestPort("80");
            logger.info("USE DEFAULT PORT: Missing port. SET default port to be 80");
        }
        if (this.getRequestUrlPostfix() == null || this.getRequestUrlPostfix().trim().isEmpty()) {
            this.setRequestUrlPostfix("");
            logger.info("USE DEFAULT URL: RequestUrlPostfix is null or empty. SET as empty \"\". e.g. just want to GET http://parallec.io");
        }
        if (this.isPollable() && this.getHttpPollerProcessor() == null) {
            throw new ParallelTaskInvalidException("set pollable but httpPollerProcessor is null!! Invalid. please set httpPollerProcessor() ");
        }
        return true;
    }

    public String getRequestPort() {
        return this.requestPort;
    }

    public void setRequestPort(String requestPort) {
        this.requestPort = requestPort;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getRequestUrlPostfix() {
        return this.requestUrlPostfix;
    }

    public void setRequestUrlPostfix(String requestUrlPostfix) {
        this.requestUrlPostfix = requestUrlPostfix != null ? requestUrlPostfix.trim() : null;
    }

    public String getEntityBody() {
        return this.entityBody;
    }

    public void setEntityBody(String entityBody) {
        this.entityBody = entityBody;
    }

    public String toString() {
        return "HttpMeta [httpMethod=" + (Object)((Object)this.httpMethod) + ", requestUrlPostfix=" + this.requestUrlPostfix + ", entityBody=" + this.entityBody + ", requestPort=" + this.requestPort + ", parallecHeader=" + this.parallecHeader + "]";
    }

    public static String replaceFullRequestContent(String requestContentTemplate, String replacementString) {
        return requestContentTemplate.replace("$PARALLEC_EMPTY_REQUEST_BODY", replacementString);
    }

    public static String replaceDefaultFullRequestContent(String requestContentTemplate) {
        return HttpMeta.replaceFullRequestContent(requestContentTemplate, "");
    }

    public ParallecHeader getHeaderMetadata() {
        return this.parallecHeader;
    }

    public void setHeaderMetadata(ParallecHeader parallecHeader) {
        this.parallecHeader = parallecHeader;
    }

    public HttpMeta(HttpMethod httpMethod, String requestUrlPostfix, String entityBody, String requestPort, ParallecHeader parallecHeader) {
        this.httpMethod = httpMethod;
        this.requestUrlPostfix = requestUrlPostfix;
        this.entityBody = entityBody;
        this.requestPort = requestPort;
        this.parallecHeader = parallecHeader;
    }

    public HttpPollerProcessor getHttpPollerProcessor() {
        return this.httpPollerProcessor;
    }

    public void setHttpPollerProcessor(HttpPollerProcessor httpPollerProcessor) {
        this.httpPollerProcessor = httpPollerProcessor;
    }

    public boolean isPollable() {
        return this.isPollable;
    }

    public void setPollable(boolean isPollable) {
        this.isPollable = isPollable;
    }

    public AsyncHttpClient getAsyncHttpClient() {
        return this.asyncHttpClient;
    }

    public void setAsyncHttpClient(AsyncHttpClient asyncHttpClient) {
        this.asyncHttpClient = asyncHttpClient;
    }
}

