/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.actor.poll;

import io.parallec.core.actor.message.ResponseOnSingeRequest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPollerProcessor {
    private static Logger logger = LoggerFactory.getLogger(HttpPollerProcessor.class);
    private String pollerType;
    private String successRegex;
    private String failureRegex;
    private String jobIdRegex;
    private String progressRegex;
    private int progressStuckTimeoutSeconds;
    private int maxPollError;
    private long pollIntervalMillis;
    private String pollerRequestTemplate;
    private String jobIdPlaceHolder;

    public HttpPollerProcessor() {
    }

    public HttpPollerProcessor(String pollerType, String successRegex, String failureRegex, String uuidRegex, String progressRegex, int progressStuckTimeoutSeconds, long pollIntervalMillis, String pollerRequestTemplate, String jobIdPlaceHolder, int maxPollError) {
        this.pollerType = pollerType;
        this.successRegex = successRegex;
        this.failureRegex = failureRegex;
        this.setJobIdRegex(uuidRegex);
        this.progressRegex = progressRegex;
        this.progressStuckTimeoutSeconds = progressStuckTimeoutSeconds;
        this.pollIntervalMillis = pollIntervalMillis;
        this.pollerRequestTemplate = pollerRequestTemplate;
        this.jobIdPlaceHolder = jobIdPlaceHolder;
        this.setMaxPollError(maxPollError);
    }

    public String getPollerRequestUrl(String uuid) {
        String pollerUrl = this.pollerRequestTemplate.replace(this.jobIdPlaceHolder, uuid);
        return pollerUrl;
    }

    public long getPollIntervalMillis() {
        return this.pollIntervalMillis;
    }

    public void setPollIntervalMillis(long pollIntervalMillis) {
        this.pollIntervalMillis = pollIntervalMillis;
    }

    public String getPollerRequestTemplate() {
        return this.pollerRequestTemplate;
    }

    public void setPollerRequestTemplate(String pollerRequestTemplate) {
        this.pollerRequestTemplate = pollerRequestTemplate;
    }

    public String getUuidFromResponse(ResponseOnSingeRequest myResponse) {
        String uuid = "NA";
        String responseBody = myResponse.getResponseBody();
        Pattern regex = Pattern.compile(this.getJobIdRegex());
        Matcher matcher = regex.matcher(responseBody);
        if (matcher.matches()) {
            uuid = matcher.group(1);
        }
        return uuid;
    }

    public double getProgressFromResponse(ResponseOnSingeRequest myResponse) {
        double progress = 0.0;
        try {
            if (myResponse == null || myResponse.isFailObtainResponse()) {
                return progress;
            }
            String responseBody = myResponse.getResponseBody();
            Pattern regex = Pattern.compile(this.progressRegex);
            Matcher matcher = regex.matcher(responseBody);
            if (matcher.matches()) {
                String progressStr = matcher.group(1);
                progress = Double.parseDouble(progressStr);
            }
        }
        catch (Exception t) {
            logger.error("fail" + t);
        }
        return progress;
    }

    public boolean ifThereIsErrorInResponse(ResponseOnSingeRequest myResponse) {
        return myResponse == null ? true : myResponse.isFailObtainResponse();
    }

    public boolean ifTaskCompletedSuccessOrFailureFromResponse(ResponseOnSingeRequest myResponse) {
        boolean isCompleted = false;
        try {
            if (myResponse == null || myResponse.isFailObtainResponse()) {
                return isCompleted;
            }
            String responseBody = myResponse.getResponseBody();
            if (responseBody.matches(this.successRegex) || responseBody.matches(this.failureRegex)) {
                isCompleted = true;
            }
        }
        catch (Exception t) {
            logger.error("fail" + t);
        }
        return isCompleted;
    }

    public String getPollerType() {
        return this.pollerType;
    }

    public void setPollerType(String pollerType) {
        this.pollerType = pollerType;
    }

    public String getFailureRegex() {
        return this.failureRegex;
    }

    public void setFailureRegex(String failureRegex) {
        this.failureRegex = failureRegex;
    }

    public String getProgressRegex() {
        return this.progressRegex;
    }

    public void setProgressRegex(String progressRegex) {
        this.progressRegex = progressRegex;
    }

    public int getProgressStuckTimeoutSeconds() {
        return this.progressStuckTimeoutSeconds;
    }

    public void setProgressStuckTimeoutSeconds(int progressStuckTimeoutSeconds) {
        this.progressStuckTimeoutSeconds = progressStuckTimeoutSeconds;
    }

    public String toString() {
        return "HttpPollerProcessor [pollerType=" + this.pollerType + ", successRegex=" + this.successRegex + ", failureRegex=" + this.failureRegex + ", uuidRegex=" + this.getJobIdRegex() + ", progressRegex=" + this.progressRegex + ", progressStuckTimeoutSeconds=" + this.progressStuckTimeoutSeconds + ", pollIntervalMillis=" + this.pollIntervalMillis + ", pollerRequestTemplate=" + this.pollerRequestTemplate + ", jobIdPlaceHolder=" + this.jobIdPlaceHolder + "]";
    }

    public String getJobIdPlaceHolder() {
        return this.jobIdPlaceHolder;
    }

    public void setJobIdPlaceHolder(String jobIdPlaceHolder) {
        this.jobIdPlaceHolder = jobIdPlaceHolder;
    }

    public String getJobIdRegex() {
        return this.jobIdRegex;
    }

    public void setJobIdRegex(String jobIdRegex) {
        this.jobIdRegex = jobIdRegex;
    }

    public int getMaxPollError() {
        return this.maxPollError;
    }

    public void setMaxPollError(int maxPollError) {
        this.maxPollError = maxPollError;
    }
}

