/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.actor;

import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.UntypedActor;
import io.parallec.core.actor.message.ResponseOnSingeRequest;
import io.parallec.core.actor.message.type.RequestWorkerMsgType;
import io.parallec.core.bean.ssh.SshMeta;
import io.parallec.core.commander.workflow.ssh.SshProvider;
import io.parallec.core.config.ParallecGlobalConfig;
import io.parallec.core.exception.ActorMessageTypeInvalidException;
import io.parallec.core.resources.TcpSshPingResourceStore;
import io.parallec.core.util.PcDateUtils;
import io.parallec.core.util.PcErrorMsgUtils;
import io.parallec.core.util.PcStringUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class SshWorker
extends UntypedActor {
    private static Logger logger = LoggerFactory.getLogger(SshWorker.class);
    private int actorMaxOperationTimeoutSec;
    private ActorRef sender = null;
    private Throwable cause;
    private int tryCount = 0;
    private Cancellable timeoutMessageCancellable = null;
    private FiniteDuration timeoutDuration = null;
    private boolean sentReply = false;
    private SshMeta sshMeta;
    private String targetHost;
    private Future<ResponseOnSingeRequest> responseFuture;

    public SshWorker(int actorMaxOperationTimeoutSec, SshMeta sshMeta, String targetHost) {
        this.actorMaxOperationTimeoutSec = actorMaxOperationTimeoutSec;
        this.sshMeta = sshMeta;
        this.targetHost = targetHost;
    }

    public void onReceive(Object message) throws Exception {
        try {
            if (message instanceof RequestWorkerMsgType) {
                switch ((RequestWorkerMsgType)((Object)message)) {
                    case PROCESS_REQUEST: {
                        ++this.tryCount;
                        if (this.tryCount == 1) {
                            this.sender = this.getSender();
                            this.timeoutDuration = Duration.create((long)this.actorMaxOperationTimeoutSec, (TimeUnit)TimeUnit.SECONDS);
                            this.timeoutMessageCancellable = this.getContext().system().scheduler().scheduleOnce(this.timeoutDuration, this.getSelf(), (Object)RequestWorkerMsgType.PROCESS_ON_TIMEOUT, (ExecutionContext)this.getContext().system().dispatcher(), this.getSelf());
                            SshTask sshTask = new SshTask(this.sshMeta, this.targetHost);
                            this.setResponseFuture(TcpSshPingResourceStore.getInstance().getThreadPoolForSshPing().submit(sshTask));
                            this.getContext().system().scheduler().scheduleOnce((FiniteDuration)Duration.create((double)0.5, (TimeUnit)TimeUnit.SECONDS), new Runnable(){

                                @Override
                                public void run() {
                                    SshWorker.this.getSelf().tell((Object)RequestWorkerMsgType.CHECK_FUTURE_STATE, SshWorker.this.getSelf());
                                }
                            }, (ExecutionContext)this.getContext().system().dispatcher());
                            break;
                        }
                        SshWorker.getLogger().error("duplicated PROCESS_REQUEST msg. ignore...");
                        break;
                    }
                    case CHECK_FUTURE_STATE: {
                        SshWorker.getLogger().debug("checking if SSH callable future completed... for " + this.targetHost);
                        if (this.getResponseFuture().isDone()) {
                            SshWorker.getLogger().debug("SSH Provider callable returned. for " + this.targetHost);
                            ResponseOnSingeRequest sshResponse = this.getResponseFuture().get();
                            this.onComplete(sshResponse);
                            break;
                        }
                        this.getContext().system().scheduler().scheduleOnce((FiniteDuration)Duration.create((double)ParallecGlobalConfig.sshFutureCheckIntervalSec, (TimeUnit)TimeUnit.SECONDS), new Runnable(){

                            @Override
                            public void run() {
                                SshWorker.this.getSelf().tell((Object)RequestWorkerMsgType.CHECK_FUTURE_STATE, SshWorker.this.getSelf());
                            }
                        }, (ExecutionContext)this.getContext().system().dispatcher());
                        break;
                    }
                    case CANCEL: {
                        SshWorker.getLogger().info("Request was CANCELLED.................on SSH host {}", (Object)this.targetHost);
                        this.cancelCancellable();
                        if (this.sender == null) {
                            this.sender = this.getSender();
                        }
                        this.reply(null, true, "REQUEST_CANCELED", "REQUEST_CANCELED", "NA", -1);
                        break;
                    }
                    case PROCESS_ON_EXCEPTION: {
                        String displayError = PcErrorMsgUtils.replaceErrorMsg(this.cause.toString());
                        String stackTrace = PcStringUtils.printStackTrace(this.cause);
                        this.cancelCancellable();
                        this.reply(null, true, displayError, stackTrace, "NA", -1);
                        break;
                    }
                    case PROCESS_ON_TIMEOUT: {
                        SshWorker.getLogger().error("Inside PROCESS_ON_TIMEOUT.................target: " + this.targetHost + "......... at " + PcDateUtils.getNowDateTimeStrStandard());
                        this.cancelCancellable();
                        String errorMsg = String.format("SshWorker Timedout after %d SEC (no response but no exception catched). Details more info", this.actorMaxOperationTimeoutSec);
                        this.reply(null, true, errorMsg, errorMsg, "NA", -1);
                        break;
                    }
                }
            } else {
                this.unhandled(message);
                this.cause = new ActorMessageTypeInvalidException("ActorMessageTypeInvalidException error for host " + this.targetHost);
                this.getSelf().tell((Object)RequestWorkerMsgType.PROCESS_ON_EXCEPTION, this.getSelf());
            }
        }
        catch (Exception e) {
            this.cause = e;
            this.getSelf().tell((Object)RequestWorkerMsgType.PROCESS_ON_EXCEPTION, this.getSelf());
        }
    }

    public void onComplete(ResponseOnSingeRequest sshResponse) {
        this.cancelCancellable();
        this.reply(sshResponse.getResponseBody(), sshResponse.isFailObtainResponse(), sshResponse.getErrorMessage(), null, sshResponse.getStatusCode(), sshResponse.getStatusCodeInt());
    }

    public void cancelCancellable() {
        if (this.timeoutMessageCancellable != null) {
            this.timeoutMessageCancellable.cancel();
        }
        if (this.getResponseFuture() != null && !this.getResponseFuture().isDone()) {
            this.getResponseFuture().cancel(true);
        }
    }

    private void reply(String response, boolean failObtainResponse, String errorMessage, String stackTrace, String statusCode, int statusCodeInt) {
        if (!this.isSentReply()) {
            this.sentReply = true;
            ResponseOnSingeRequest res = new ResponseOnSingeRequest(response, failObtainResponse, errorMessage, stackTrace, statusCode, statusCodeInt, PcDateUtils.getNowDateTimeStrStandard());
            if (!this.getContext().system().deadLetters().equals((Object)this.sender)) {
                this.sender.tell((Object)res, this.getSelf());
            }
            SshWorker.getLogger().debug("DEBUG: real response: " + response + " err: " + errorMessage);
            this.getContext().stop(this.getSelf());
        }
    }

    public boolean isSentReply() {
        return this.sentReply;
    }

    public void setSentReply(boolean sentReply) {
        this.sentReply = sentReply;
    }

    public Future<ResponseOnSingeRequest> getResponseFuture() {
        return this.responseFuture;
    }

    public void setResponseFuture(Future<ResponseOnSingeRequest> responseFuture) {
        this.responseFuture = responseFuture;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        SshWorker.logger = logger;
    }

    private static class SshTask
    implements Callable<ResponseOnSingeRequest> {
        private SshMeta sshMeta;
        private String targetHost;

        public SshTask(SshMeta sshMeta, String targetHost) {
            this.sshMeta = sshMeta;
            this.targetHost = targetHost;
        }

        @Override
        public ResponseOnSingeRequest call() throws Exception {
            SshProvider sshProvider = new SshProvider(this.sshMeta, this.targetHost);
            ResponseOnSingeRequest sshResponse = sshProvider.executeSshCommand();
            return sshResponse;
        }
    }
}

