/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.actor;

import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.Props;
import akka.actor.UntypedActor;
import com.ning.http.client.AsyncHttpClient;
import io.parallec.core.RequestProtocol;
import io.parallec.core.ResponseOnSingleTask;
import io.parallec.core.actor.HttpWorker;
import io.parallec.core.actor.PingWorker;
import io.parallec.core.actor.SshWorker;
import io.parallec.core.actor.TcpWorker;
import io.parallec.core.actor.message.ResponseOnSingeRequest;
import io.parallec.core.actor.message.type.OperationWorkerMsgType;
import io.parallec.core.actor.message.type.RequestWorkerMsgType;
import io.parallec.core.actor.poll.HttpPollerProcessor;
import io.parallec.core.actor.poll.PollerData;
import io.parallec.core.bean.TaskRequest;
import io.parallec.core.config.ParallelTaskConfigDefault;
import io.parallec.core.exception.ActorMessageTypeInvalidException;
import io.parallec.core.resources.HttpMethod;
import io.parallec.core.util.PcDateUtils;
import io.parallec.core.util.PcHttpUtils;
import io.parallec.core.util.PcStringUtils;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class OperationWorker
extends UntypedActor {
    private final AsyncHttpClient client;
    private static Logger logger = LoggerFactory.getLogger(OperationWorker.class);
    private int pollingErrorCount = 0;
    private final TaskRequest request;
    private ResponseOnSingleTask response = new ResponseOnSingleTask();
    private ActorRef asyncWorker = null;
    private ActorRef sender = null;
    private Cancellable timeoutMessageCancellable = null;
    private Cancellable pollMessageCancellable = null;
    private FiniteDuration timeoutDuration = null;
    private int actorMaxOperationTimeoutSec = ParallelTaskConfigDefault.actorMaxOperationTimeoutSec;
    private long startTimeMillis = 0L;
    private boolean sentReply = false;
    private String trueTargetNode;
    private PollerData pollerData = null;
    private HttpPollerProcessor httpPollerProcessor = null;

    public OperationWorker(TaskRequest request, AsyncHttpClient client, HttpPollerProcessor httpPollerProcessor) {
        this.client = client;
        this.request = request;
        String string = this.trueTargetNode = request.getHostUniform() == null ? request.getHost() : request.getHostUniform();
        if (request.isPollable()) {
            this.pollerData = new PollerData();
            this.httpPollerProcessor = httpPollerProcessor;
            logger.info("Request is Pollable: poller info: " + httpPollerProcessor.toString());
        }
    }

    public void onReceive(Object message) throws Exception {
        block10: {
            try {
                if (message instanceof OperationWorkerMsgType) {
                    switch ((OperationWorkerMsgType)((Object)message)) {
                        case PROCESS_REQUEST: {
                            this.processMainRequest();
                            break;
                        }
                        case POLL_PROGRESS: {
                            this.pollProgress();
                            break;
                        }
                        case OPERATION_TIMEOUT: {
                            this.operationTimeout();
                            break;
                        }
                        case CANCEL: {
                            this.cancel();
                        }
                    }
                    break block10;
                }
                if (message instanceof ResponseOnSingeRequest) {
                    ResponseOnSingeRequest myResponse = (ResponseOnSingeRequest)message;
                    this.handleHttpWorkerResponse(myResponse);
                    break block10;
                }
                this.unhandled(message);
                throw new ActorMessageTypeInvalidException("invalid message type to OperationWorker");
            }
            catch (Exception e) {
                this.reply(true, e.toString(), PcStringUtils.printStackTrace(e), "NA", -1);
            }
        }
    }

    private final void pollProgress() {
        String pollUrl = this.httpPollerProcessor.getPollerRequestUrl(this.pollerData.getJobId());
        HttpMethod pollerHttpMethod = HttpMethod.GET;
        String postBodyForPoller = "";
        ActorRef pollerWorker = this.getContext().actorOf(Props.create(HttpWorker.class, (Object[])new Object[]{this.actorMaxOperationTimeoutSec, this.client, String.format("%s://%s:%d%s", this.request.getProtocol().toString(), this.trueTargetNode, this.request.getPort(), pollUrl), pollerHttpMethod, "", this.request.getHttpHeaderMap()}));
        logger.info("POLL_REQ_SEND" + pollUrl + " " + PcDateUtils.getNowDateTimeStrStandard());
        this.pollerData.getPollingHistoryMap().put("POLL_REQ_SEND_" + PcDateUtils.getNowDateTimeStrConciseNoZone(), pollUrl);
        pollerWorker.tell((Object)RequestWorkerMsgType.PROCESS_REQUEST, this.getSelf());
        this.cancelExistingIfAnyAndScheduleTimeoutCall();
    }

    private final void handleHttpWorkerResponse(ResponseOnSingeRequest respOnSingleReq) throws Exception {
        String responseContent = respOnSingleReq.getResponseBody();
        this.response.setResponseContent(respOnSingleReq.getResponseBody());
        if (this.request.isPollable()) {
            boolean scheduleNextPoll = false;
            boolean errorFindingUuid = false;
            if (!this.pollerData.isUuidHasBeenSet()) {
                String jobId = this.httpPollerProcessor.getUuidFromResponse(respOnSingleReq);
                if (jobId.equalsIgnoreCase("NA")) {
                    errorFindingUuid = true;
                    ++this.pollingErrorCount;
                    logger.error("!!POLLING_JOB_FAIL_FIND_JOBID_IN_RESPONSE!! FAIL FAST NOW. PLEASE CHECK getJobIdRegex or retry. DEBUG: REGEX_JOBID: " + this.httpPollerProcessor.getJobIdRegex() + "RESPONSE: " + respOnSingleReq.getResponseBody() + " polling Error count" + this.pollingErrorCount + " at " + PcDateUtils.getNowDateTimeStrStandard());
                    this.pollerData.setError(true);
                    this.pollerData.setComplete(true);
                } else {
                    this.pollerData.setJobIdAndMarkHasBeenSet(jobId);
                    this.pollerData.setError(this.httpPollerProcessor.ifThereIsErrorInResponse(respOnSingleReq));
                }
            }
            if (!this.pollerData.isError()) {
                this.pollerData.setComplete(this.httpPollerProcessor.ifTaskCompletedSuccessOrFailureFromResponse(respOnSingleReq));
                this.pollerData.setCurrentProgress(this.httpPollerProcessor.getProgressFromResponse(respOnSingleReq));
            }
            boolean bl = scheduleNextPoll = !this.pollerData.isComplete() && this.pollingErrorCount <= this.httpPollerProcessor.getMaxPollError();
            if (scheduleNextPoll && this.pollingErrorCount <= this.httpPollerProcessor.getMaxPollError()) {
                this.pollMessageCancellable = this.getContext().system().scheduler().scheduleOnce(Duration.create((long)this.httpPollerProcessor.getPollIntervalMillis(), (TimeUnit)TimeUnit.MILLISECONDS), this.getSelf(), (Object)OperationWorkerMsgType.POLL_PROGRESS, (ExecutionContext)this.getContext().system().dispatcher(), this.getSelf());
                logger.info("\nPOLLER_NOW_ANOTHER_POLL: POLL_RECV_SEND" + String.format("PROGRESS:%.3f, BODY:%s ", this.pollerData.getCurrentProgress(), responseContent, PcDateUtils.getNowDateTimeStrStandard()));
                String responseContentNew = errorFindingUuid ? responseContent + "_PollingErrorCount:" + this.pollingErrorCount : responseContent;
                logger.info(responseContentNew);
                this.pollerData.getPollingHistoryMap().put("RECV_" + PcDateUtils.getNowDateTimeStrConciseNoZone(), String.format("PROGRESS:%.3f, BODY:%s", this.pollerData.getCurrentProgress(), responseContent));
                return;
            }
            this.pollerData.getPollingHistoryMap().put("RECV_" + PcDateUtils.getNowDateTimeStrConciseNoZone(), String.format("POLL_COMPLETED_OR_ERROR: PROGRESS:%.3f, BODY:%s ", this.pollerData.getCurrentProgress(), responseContent));
        }
        this.reply(respOnSingleReq.isFailObtainResponse(), respOnSingleReq.getErrorMessage(), respOnSingleReq.getStackTrace(), respOnSingleReq.getStatusCode(), respOnSingleReq.getStatusCodeInt(), respOnSingleReq.getReceiveTime());
    }

    private final void processMainRequest() {
        this.sender = this.getSender();
        this.startTimeMillis = System.currentTimeMillis();
        this.timeoutDuration = Duration.create((long)this.request.getActorMaxOperationTimeoutSec(), (TimeUnit)TimeUnit.SECONDS);
        this.actorMaxOperationTimeoutSec = this.request.getActorMaxOperationTimeoutSec();
        if (this.request.getProtocol() == RequestProtocol.HTTP || this.request.getProtocol() == RequestProtocol.HTTPS) {
            String urlComplete = String.format("%s://%s:%d%s", this.request.getProtocol().toString(), this.trueTargetNode, this.request.getPort(), this.request.getResourcePath());
            if (!PcHttpUtils.isUrlValid(urlComplete.trim())) {
                String errMsg = "INVALID_URL";
                logger.error("INVALID_URL: " + urlComplete + " return..");
                this.reply(true, errMsg, errMsg, "NA", -1);
                return;
            }
            logger.debug("url pass validation: " + urlComplete);
            this.asyncWorker = this.getContext().actorOf(Props.create(HttpWorker.class, (Object[])new Object[]{this.actorMaxOperationTimeoutSec, this.client, urlComplete, this.request.getHttpMethod(), this.request.getPostData(), this.request.getHttpHeaderMap()}));
        } else if (this.request.getProtocol() == RequestProtocol.SSH) {
            this.asyncWorker = this.getContext().actorOf(Props.create(SshWorker.class, (Object[])new Object[]{this.actorMaxOperationTimeoutSec, this.request.getSshMeta(), this.trueTargetNode}));
        } else if (this.request.getProtocol() == RequestProtocol.TCP) {
            this.asyncWorker = this.getContext().actorOf(Props.create(TcpWorker.class, (Object[])new Object[]{this.actorMaxOperationTimeoutSec, this.request.getTcpMeta(), this.trueTargetNode}));
        } else if (this.request.getProtocol() == RequestProtocol.PING) {
            this.asyncWorker = this.getContext().actorOf(Props.create(PingWorker.class, (Object[])new Object[]{this.actorMaxOperationTimeoutSec, this.request.getPingMeta(), this.trueTargetNode}));
        }
        this.asyncWorker.tell((Object)RequestWorkerMsgType.PROCESS_REQUEST, this.getSelf());
        this.cancelExistingIfAnyAndScheduleTimeoutCall();
    }

    private void cancelExistingIfAnyAndScheduleTimeoutCall() {
        if (this.timeoutMessageCancellable != null && !this.timeoutMessageCancellable.isCancelled()) {
            this.timeoutMessageCancellable.cancel();
        }
        this.timeoutMessageCancellable = this.getContext().system().scheduler().scheduleOnce(this.timeoutDuration, this.getSelf(), (Object)OperationWorkerMsgType.OPERATION_TIMEOUT, (ExecutionContext)this.getContext().system().dispatcher(), this.getSelf());
    }

    private final void operationTimeout() {
        this.cancelCancellable();
        if (this.asyncWorker != null && !this.asyncWorker.isTerminated()) {
            this.asyncWorker.tell((Object)RequestWorkerMsgType.PROCESS_ON_TIMEOUT, this.getSelf());
        } else {
            logger.info("asyncWorker has been killed or uninitialized (null). Not send PROCESS ON TIMEOUT.\nREQ: " + this.request.toString());
            this.reply(true, "OPERATION_TIMEOUT", "OPERATION_TIMEOUT", "NA", -1);
        }
    }

    private final void cancel() {
        this.cancelCancellable();
        if (this.asyncWorker != null && this.asyncWorker.isTerminated()) {
            this.asyncWorker.tell((Object)RequestWorkerMsgType.CANCEL, this.getSelf());
        } else {
            logger.info("asyncWorker has not been initilized (null). Will not tell it cancel");
            if (this.sender == null) {
                this.sender = this.getSender();
            }
            this.reply(true, "REQUEST_CANCELED", "REQUEST_CANCELED", "NA", -1);
        }
    }

    private final void cancelCancellable() {
        if (this.timeoutMessageCancellable != null && !this.timeoutMessageCancellable.isCancelled()) {
            this.timeoutMessageCancellable.cancel();
        }
        if (this.pollMessageCancellable != null && !this.pollMessageCancellable.isCancelled()) {
            this.pollMessageCancellable.cancel();
        }
    }

    private final void reply(boolean error, String errorMessage, String stackTrace, String statusCode, int statusCodeInt) {
        this.reply(error, errorMessage, stackTrace, statusCode, statusCodeInt, "NA");
    }

    private final void reply(boolean error, String errorMessage, String stackTrace, String statusCode, int statusCodeInt, String receiveTime) {
        if (!this.sentReply) {
            this.sentReply = true;
            this.cancelCancellable();
            long operationTimeMillis = System.currentTimeMillis() - this.startTimeMillis;
            if (this.sender != null && !this.sender.equals((Object)this.getContext().system().deadLetters())) {
                this.response.setReceiveTimeInManager(PcDateUtils.getNowDateTimeStrStandard());
                this.response.setError(error);
                this.response.setErrorMessage(errorMessage);
                this.response.setStackTrace(stackTrace);
                this.response.setOperationTimeMillis(operationTimeMillis);
                this.response.setRequest(this.request);
                this.response.setStatusCode(statusCode);
                this.response.setStatusCodeInt(statusCodeInt);
                this.response.setReceiveTime(receiveTime);
                if (this.request.isPollable() && this.pollerData != null) {
                    this.response.getPollingHistoryMap().putAll(this.pollerData.getPollingHistoryMap());
                }
                if (this.request != null && this.request.getHandler() != null) {
                    try {
                        this.request.getHandler().onCompleted(this.response, this.request.getResponseContext());
                    }
                    catch (Exception t) {
                        logger.error("Error handling onCompleted in manager for response: {} Error {}", (Object)this.response.toString(), (Object)t.getLocalizedMessage());
                    }
                }
                this.sender.tell((Object)this.response, this.getSelf());
            }
            if (this.asyncWorker != null && !this.asyncWorker.isTerminated()) {
                this.getContext().stop(this.asyncWorker);
            }
        }
    }
}

