/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core;

import com.google.common.base.Strings;
import com.ning.http.client.AsyncHttpClient;
import io.parallec.core.HostsSourceType;
import io.parallec.core.ParallecHeader;
import io.parallec.core.ParallecResponseHandler;
import io.parallec.core.ParallelTask;
import io.parallec.core.RequestProtocol;
import io.parallec.core.actor.poll.HttpPollerProcessor;
import io.parallec.core.bean.HttpMeta;
import io.parallec.core.bean.StrStrMap;
import io.parallec.core.bean.TargetHostMeta;
import io.parallec.core.bean.TaskRunMode;
import io.parallec.core.bean.ping.PingMeta;
import io.parallec.core.bean.ping.PingMode;
import io.parallec.core.bean.ssh.SshLoginType;
import io.parallec.core.bean.ssh.SshMeta;
import io.parallec.core.bean.tcp.TcpMeta;
import io.parallec.core.config.HandlerExecutionLocation;
import io.parallec.core.config.ParallelTaskConfig;
import io.parallec.core.exception.ParallelTaskInvalidException;
import io.parallec.core.exception.TargetHostsLoadException;
import io.parallec.core.task.ParallelTaskManager;
import io.parallec.core.task.ParallelTaskState;
import io.parallec.core.task.RequestReplacementType;
import io.parallec.core.task.TaskErrorMeta;
import io.parallec.core.taskbuilder.targethosts.ITargetHostsBuilder;
import io.parallec.core.taskbuilder.targethosts.TargetHostsBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.netty.channel.ChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelTaskBuilder {
    private static Logger logger = LoggerFactory.getLogger(ParallelTaskBuilder.class);
    private HttpMeta httpMeta = new HttpMeta();
    private SshMeta sshMeta = new SshMeta();
    private TcpMeta tcpMeta = new TcpMeta();
    private PingMeta pingMeta = new PingMeta();
    private TargetHostMeta targetHostMeta;
    private final Map<String, StrStrMap> replacementVarMapNodeSpecific = new HashMap<String, StrStrMap>();
    private Map<String, String> replacementVarMap = new HashMap<String, String>();
    private RequestReplacementType requestReplacementType = RequestReplacementType.NO_REPLACEMENT;
    private List<String> targetHosts = new ArrayList<String>();
    private ITargetHostsBuilder targetHostBuilder = new TargetHostsBuilder();
    private Map<String, Object> responseContext = new HashMap<String, Object>();
    public TaskRunMode mode = TaskRunMode.SYNC;
    private ParallelTaskConfig config = new ParallelTaskConfig();
    private RequestProtocol requestProtocol = null;
    private int concurrency = 0;

    public ParallelTaskBuilder() {
        logger.info("Initialized task builder with default config");
    }

    public Map<String, Object> getResponseContext() {
        return this.responseContext;
    }

    public ParallelTaskBuilder setResponseContext(Map<String, Object> responseContext) {
        if (responseContext != null) {
            this.responseContext = responseContext;
        } else {
            logger.error("context cannot be null. skip set.");
        }
        return this;
    }

    public ParallelTaskBuilder handleInWorker() {
        this.config.setHandlerExecutionLocation(HandlerExecutionLocation.OPERATION_WORKER);
        return this;
    }

    public ParallelTaskBuilder handleInManager() {
        this.config.setHandlerExecutionLocation(HandlerExecutionLocation.MANAGER);
        return this;
    }

    public ParallelTaskBuilder async() {
        this.mode = TaskRunMode.ASYNC;
        return this;
    }

    public ParallelTaskBuilder sync() {
        this.mode = TaskRunMode.SYNC;
        return this;
    }

    public void setMode(TaskRunMode mode) {
        this.mode = mode;
    }

    public ParallelTask execute(ParallecResponseHandler handler) {
        ParallelTask task = new ParallelTask();
        try {
            ParallelTask taskReal;
            this.targetHostMeta = new TargetHostMeta(this.targetHosts);
            task = taskReal = new ParallelTask(this.requestProtocol, this.concurrency, this.httpMeta, this.targetHostMeta, this.sshMeta, this.tcpMeta, this.pingMeta, handler, this.responseContext, this.replacementVarMapNodeSpecific, this.replacementVarMap, this.requestReplacementType, this.config);
            logger.info("***********START_PARALLEL_HTTP_TASK_" + task.getTaskId() + "***********");
            task.validateWithFillDefault();
            task.setSubmitTime(System.currentTimeMillis());
            if (task.getConfig().isEnableCapacityAwareTaskScheduler()) {
                ParallelTaskManager.getInstance().initTaskSchedulerIfNot();
                ParallelTaskManager.getInstance().getWaitQ().add(task);
                logger.info("Enabled CapacityAwareTaskScheduler. Submitted task to waitQ in builder.. " + task.getTaskId());
            } else {
                logger.info("Disabled CapacityAwareTaskScheduler. Immediately execute task {} ", (Object)task.getTaskId());
                Runnable director = new Runnable(){

                    @Override
                    public void run() {
                        ParallelTaskManager.getInstance().generateUpdateExecuteTask(taskReal);
                    }
                };
                new Thread(director).start();
            }
            if (this.mode == TaskRunMode.SYNC) {
                logger.info("Executing task {} in SYNC mode...  ", (Object)task.getTaskId());
                while (task != null && !task.isCompleted()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        logger.error("fail sleep interrup exception in executing task " + e);
                    }
                }
            }
        }
        catch (ParallelTaskInvalidException ex) {
            logger.info("Request is invalid with missing parts. Details: " + ex.getMessage() + " Cannot execute at this time. " + " Please review your request and try again.\nCommand:" + this.httpMeta.toString());
            task.setState(ParallelTaskState.COMPLETED_WITH_ERROR);
            task.getTaskErrorMetas().add(new TaskErrorMeta(TaskErrorMeta.TaskErrorType.VALIDATION_ERROR, "validation eror"));
        }
        catch (Exception t) {
            logger.error("fail task builder. Unknown error: " + t, (Throwable)t);
            task.setState(ParallelTaskState.COMPLETED_WITH_ERROR);
            task.getTaskErrorMetas().add(new TaskErrorMeta(TaskErrorMeta.TaskErrorType.UNKNOWN, "validation eror", t));
        }
        logger.info("***********FINISH_PARALLEL_HTTP_TASK_" + task.getTaskId() + "***********");
        return task;
    }

    public boolean validation() throws ParallelTaskInvalidException {
        ParallelTask task = new ParallelTask();
        this.targetHostMeta = new TargetHostMeta(this.targetHosts);
        task = new ParallelTask(this.requestProtocol, this.concurrency, this.httpMeta, this.targetHostMeta, this.sshMeta, this.tcpMeta, this.pingMeta, null, this.responseContext, this.replacementVarMapNodeSpecific, this.replacementVarMap, this.requestReplacementType, this.config);
        boolean valid = false;
        try {
            valid = task.validateWithFillDefault();
        }
        catch (ParallelTaskInvalidException e) {
            logger.info("task is invalid " + e);
        }
        return valid;
    }

    public ParallelTaskBuilder setProtocol(RequestProtocol protocol) {
        this.requestProtocol = protocol;
        return this;
    }

    public ParallelTaskBuilder setConcurrency(int concurrency) {
        this.concurrency = concurrency;
        return this;
    }

    public ParallelTaskBuilder setHttpEntityBody(String body) {
        this.httpMeta.setEntityBody(body);
        return this;
    }

    public ParallelTaskBuilder setHttpHeaders(ParallecHeader pheader) {
        this.httpMeta.setHeaderMetadata(pheader);
        return this;
    }

    public ParallelTaskBuilder setHttpPort(int port) {
        this.httpMeta.setRequestPort(Integer.toString(port));
        return this;
    }

    public ParallelTaskBuilder setAsyncHttpClient(AsyncHttpClient asyncHttpClient) {
        this.httpMeta.setAsyncHttpClient(asyncHttpClient);
        return this;
    }

    public HttpMeta getHttpMeta() {
        return this.httpMeta;
    }

    public void setHttpMeta(HttpMeta httpMeta) {
        this.httpMeta = httpMeta;
    }

    public AsyncHttpClient getAsyncHttpClient() {
        return this.httpMeta.getAsyncHttpClient();
    }

    public List<String> getTargetHosts() {
        return this.targetHosts;
    }

    public ParallelTaskBuilder setTargetHostsFromList(List<String> targetHosts) {
        this.targetHosts = this.targetHostBuilder.setTargetHostsFromList(targetHosts);
        return this;
    }

    public ParallelTaskBuilder setTargetHostsFromString(String targetHostsStr) {
        this.targetHosts = this.targetHostBuilder.setTargetHostsFromString(targetHostsStr);
        return this;
    }

    public ParallelTaskBuilder setTargetHostsFromJsonPath(String jsonPath, String sourcePath, HostsSourceType sourceType) throws TargetHostsLoadException {
        this.targetHosts = this.targetHostBuilder.setTargetHostsFromJsonPath(jsonPath, sourcePath, sourceType);
        return this;
    }

    public ParallelTaskBuilder setTargetHostsFromLineByLineText(String sourcePath, HostsSourceType sourceType) throws TargetHostsLoadException {
        this.targetHosts = this.targetHostBuilder.setTargetHostsFromLineByLineText(sourcePath, sourceType);
        return this;
    }

    public ParallelTaskBuilder setTargetHostsFromCmsQueryUrl(String cmsQueryUrl) throws TargetHostsLoadException {
        this.targetHosts = this.targetHostBuilder.setTargetHostsFromCmsQueryUrl(cmsQueryUrl);
        return this;
    }

    public ParallelTaskBuilder setTargetHostsFromCmsQueryUrl(String cmsQueryUrl, String projection) throws TargetHostsLoadException {
        this.targetHosts = this.targetHostBuilder.setTargetHostsFromCmsQueryUrl(cmsQueryUrl, projection);
        return this;
    }

    public ITargetHostsBuilder getTargetHostBuilder() {
        return this.targetHostBuilder;
    }

    public void setTargetHostBuilder(ITargetHostsBuilder thb) {
        this.targetHostBuilder = thb;
    }

    public TaskRunMode getMode() {
        return this.mode;
    }

    public TargetHostMeta getTargetHostMeta() {
        return this.targetHostMeta;
    }

    public void setTargetHostMeta(TargetHostMeta targetHostMeta) {
        this.targetHostMeta = targetHostMeta;
    }

    public Map<String, StrStrMap> getReplacementVarMapNodeSpecific() {
        return this.replacementVarMapNodeSpecific;
    }

    public ParallelTaskBuilder setReplacementVarMapNodeSpecific(Map<String, StrStrMap> replacementVarMapNodeSpecific) {
        this.replacementVarMapNodeSpecific.clear();
        this.replacementVarMapNodeSpecific.putAll(replacementVarMapNodeSpecific);
        this.requestReplacementType = RequestReplacementType.TARGET_HOST_SPECIFIC_VAR_REPLACEMENT;
        logger.info("Set requestReplacementType as {}" + this.requestReplacementType.toString());
        return this;
    }

    public ParallelTaskBuilder setReplaceVarMapToSingleTargetFromMap(Map<String, StrStrMap> replacementVarMapNodeSpecific, String uniformTargetHost) {
        this.setReplacementVarMapNodeSpecific(replacementVarMapNodeSpecific);
        if (uniformTargetHost == null || uniformTargetHost.isEmpty()) {
            logger.error("uniform target host is empty or null. skil setting.");
            return this;
        }
        for (Map.Entry<String, StrStrMap> entry : replacementVarMapNodeSpecific.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().addPair("PARALLEC_UNIFORM_TARGET_HOST", uniformTargetHost);
        }
        return this;
    }

    public ParallelTaskBuilder setReplaceVarMapToSingleTargetSingleVar(String variable, List<String> replaceList, String uniformTargetHost) {
        if (uniformTargetHost == null || uniformTargetHost.isEmpty()) {
            logger.error("uniform target host is empty or null. skil setting.");
            return this;
        }
        this.replacementVarMapNodeSpecific.clear();
        this.targetHosts.clear();
        int i = 0;
        for (String replace : replaceList) {
            if (replace == null) continue;
            String hostName = "API_" + i;
            this.replacementVarMapNodeSpecific.put(hostName, new StrStrMap().addPair(variable, replace).addPair("PARALLEC_UNIFORM_TARGET_HOST", uniformTargetHost));
            this.targetHosts.add(hostName);
            ++i;
        }
        this.requestReplacementType = RequestReplacementType.TARGET_HOST_SPECIFIC_VAR_REPLACEMENT;
        logger.info("Set requestReplacementType as {} for single target. Will disable the set target hosts.Also Simulated Now Already set targetHost list with size {}. \nPLEASE NOT TO SET TARGET HOSTS AGAIN WITH THIS API.", (Object)this.requestReplacementType.toString(), (Object)this.targetHosts.size());
        return this;
    }

    public ParallelTaskBuilder setReplaceVarMapToSingleTarget(List<StrStrMap> replacementVarMapList, String uniformTargetHost) {
        if (Strings.isNullOrEmpty((String)uniformTargetHost)) {
            logger.error("uniform target host is empty or null. skil setting.");
            return this;
        }
        this.replacementVarMapNodeSpecific.clear();
        this.targetHosts.clear();
        int i = 0;
        for (StrStrMap ssm : replacementVarMapList) {
            if (ssm == null) continue;
            String hostName = "API_" + i;
            ssm.addPair("PARALLEC_UNIFORM_TARGET_HOST", uniformTargetHost);
            this.replacementVarMapNodeSpecific.put(hostName, ssm);
            this.targetHosts.add(hostName);
            ++i;
        }
        this.requestReplacementType = RequestReplacementType.TARGET_HOST_SPECIFIC_VAR_REPLACEMENT;
        logger.info("Set requestReplacementType as {} for single target. Will disable the set target hosts.Also Simulated Now Already set targetHost list with size {}. \nPLEASE NOT TO SET TARGET HOSTS AGAIN WITH THIS API.", (Object)this.requestReplacementType.toString(), (Object)this.targetHosts.size());
        return this;
    }

    public Map<String, String> getReplacementVarMap() {
        return this.replacementVarMap;
    }

    public ParallelTaskBuilder setReplacementVarMap(Map<String, String> replacementVarMap) {
        this.replacementVarMap = replacementVarMap;
        this.requestReplacementType = RequestReplacementType.UNIFORM_VAR_REPLACEMENT;
        return this;
    }

    public RequestReplacementType getRequestReplacementType() {
        return this.requestReplacementType;
    }

    public ParallelTaskBuilder setRequestReplacementType(RequestReplacementType requestReplacementType) {
        this.requestReplacementType = requestReplacementType;
        return this;
    }

    public ParallelTaskBuilder setHttpPollable(boolean isPollable) {
        this.httpMeta.setPollable(isPollable);
        return this;
    }

    public ParallelTaskBuilder setHttpPollerProcessor(HttpPollerProcessor httpPollerProcessor) {
        this.httpMeta.setHttpPollerProcessor(httpPollerProcessor);
        this.httpMeta.setPollable(true);
        return this;
    }

    public String toString() {
        return "PTaskBuilder [acm=" + this.httpMeta + ", nodeGroupSourceMetadata=" + this.targetHostMeta + ", replacementVarMapNodeSpecific=" + this.replacementVarMapNodeSpecific + ", replacementVarMap=" + this.replacementVarMap + ", requestReplacementType=" + (Object)((Object)this.requestReplacementType) + ", targetHosts=" + this.targetHosts + ", thb=" + this.targetHostBuilder + ", responseContext=" + this.responseContext + ", mode=" + (Object)((Object)this.mode) + "]";
    }

    public ParallelTaskBuilder setSshCommandLine(String commandLine) {
        this.sshMeta.setCommandLine(commandLine);
        return this;
    }

    public ParallelTaskBuilder setRunAsSuperUser(Boolean runAsSuperUser) {
        this.sshMeta.setRunAsSuperUser(runAsSuperUser);
        return this;
    }

    public ParallelTaskBuilder setSshPort(int sshPort) {
        this.sshMeta.setSshPort(sshPort);
        return this;
    }

    public ParallelTaskBuilder setSshUserName(String userName) {
        this.sshMeta.setUserName(userName);
        return this;
    }

    public ParallelTaskBuilder setSshPassword(String password) {
        this.sshMeta.setPassword(password);
        this.sshMeta.setSshLoginType(SshLoginType.PASSWORD);
        return this;
    }

    public ParallelTaskBuilder setSshLoginType(SshLoginType sshLoginType) {
        this.sshMeta.setSshLoginType(sshLoginType);
        return this;
    }

    public ParallelTaskBuilder setSshPrivKeyRelativePath(String privKeyRelativePath) {
        this.sshMeta.setPrivKeyRelativePath(privKeyRelativePath);
        this.sshMeta.setSshLoginType(SshLoginType.KEY);
        return this;
    }

    public ParallelTaskBuilder setSshPrivKeyRelativePathWtihPassphrase(String privKeyRelativePath, String passphrase) {
        this.sshMeta.setPrivKeyRelativePath(privKeyRelativePath);
        this.sshMeta.setPrivKeyUsePassphrase(true);
        this.sshMeta.setPassphrase(passphrase);
        this.sshMeta.setSshLoginType(SshLoginType.KEY);
        return this;
    }

    public ParallelTaskBuilder setSshConnectionTimeoutMillis(int sshConnectionTimeoutMillis) {
        this.sshMeta.setSshConnectionTimeoutMillis(sshConnectionTimeoutMillis);
        return this;
    }

    public ParallelTaskBuilder setTcpPort(int tcpPort) {
        this.tcpMeta.setTcpPort(tcpPort);
        return this;
    }

    public ParallelTaskBuilder setTcpConnectTimeoutMillis(int tcpConnectTimeoutMillis) {
        this.tcpMeta.setTcpConnectTimeoutMillis(tcpConnectTimeoutMillis);
        return this;
    }

    public ParallelTaskBuilder setTcpIdleTimeoutSec(int tcpIdleTimeoutSec) {
        this.tcpMeta.setTcpIdleTimeoutSec(tcpIdleTimeoutSec);
        return this;
    }

    public ParallelTaskBuilder setTcpChannelFactory(ChannelFactory channelFactory) {
        this.tcpMeta.setChannelFactory(channelFactory);
        return this;
    }

    public ParallelTaskBuilder setConfig(ParallelTaskConfig config) {
        this.config = config;
        return this;
    }

    public ParallelTaskConfig getConfig() {
        return this.config;
    }

    public ParallelTaskBuilder setSaveResponseToTask(boolean saveResponseToTask) {
        this.config.setSaveResponseToTask(saveResponseToTask);
        return this;
    }

    public ParallelTaskBuilder setEnableCapacityAwareTaskScheduler(boolean enableCapacityAwareTaskScheduler) {
        this.config.setEnableCapacityAwareTaskScheduler(enableCapacityAwareTaskScheduler);
        return this;
    }

    public ParallelTaskBuilder setAutoSaveLogToLocal(boolean autoSaveLogToLocal) {
        this.config.setAutoSaveLogToLocal(autoSaveLogToLocal);
        return this;
    }

    public TcpMeta getTcpMeta() {
        return this.tcpMeta;
    }

    public void setTcpMeta(TcpMeta tcpMeta) {
        this.tcpMeta = tcpMeta;
    }

    public RequestProtocol getRequestProtocol() {
        return this.requestProtocol;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public ParallelTaskBuilder setPingMode(PingMode mode) {
        this.pingMeta.setMode(mode);
        return this;
    }

    public ParallelTaskBuilder setPingTimeoutMillis(int pingTimeoutMillis) {
        this.pingMeta.setPingTimeoutMillis(pingTimeoutMillis);
        return this;
    }

    public ParallelTaskBuilder setPingNumRetries(int numRetries) {
        this.pingMeta.setNumRetries(numRetries);
        return this;
    }
}

