/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.taskbuilder.targethosts;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.parallec.core.HostsSourceType;
import io.parallec.core.exception.TargetHostsLoadException;
import io.parallec.core.taskbuilder.targethosts.ITargetHostsBuilder;
import io.parallec.core.taskbuilder.targethosts.TargetHostsBuilderHelperCms;
import io.parallec.core.util.PcFileNetworkIoUtils;
import io.parallec.core.util.PcTargetHostsUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetHostsBuilder
implements ITargetHostsBuilder {
    private static Logger logger = LoggerFactory.getLogger(TargetHostsBuilder.class);

    private String getContentFromPath(String sourcePath, HostsSourceType sourceType) throws IOException {
        String res = "";
        if (sourceType == HostsSourceType.LOCAL_FILE) {
            res = PcFileNetworkIoUtils.readFileContentToString(sourcePath);
        } else if (sourceType == HostsSourceType.URL) {
            res = PcFileNetworkIoUtils.readStringFromUrlGeneric(sourcePath);
        }
        return res;
    }

    @Override
    public List<String> setTargetHostsFromList(List<String> targetHosts) {
        ArrayList<String> targetHostsNew = new ArrayList<String>();
        targetHostsNew.addAll(targetHosts);
        int dupSize = PcTargetHostsUtils.removeDuplicateNodeList(targetHostsNew);
        if (dupSize > 0) {
            logger.info("get target hosts with duplicated hosts of " + dupSize + " with new total size of " + targetHosts.size());
        }
        return targetHostsNew;
    }

    @Override
    public List<String> setTargetHostsFromString(String targetHostsStr) {
        ArrayList<String> targetHosts = new ArrayList<String>();
        if (targetHostsStr != null) {
            boolean removeDuplicate = true;
            targetHosts.addAll(PcTargetHostsUtils.getNodeListFromStringLineSeperateOrSpaceSeperate(targetHostsStr, removeDuplicate));
        }
        return targetHosts;
    }

    @Override
    public List<String> setTargetHostsFromJsonPath(String jsonPath, String sourcePath, HostsSourceType sourceType) throws TargetHostsLoadException {
        ArrayList<String> targetHosts = new ArrayList();
        try {
            String content = this.getContentFromPath(sourcePath, sourceType);
            targetHosts = (List)JsonPath.read((String)content, (String)jsonPath, (Predicate[])new Predicate[0]);
        }
        catch (IOException e) {
            throw new TargetHostsLoadException("IEException when reading  " + sourcePath, e);
        }
        return targetHosts;
    }

    @Override
    public List<String> setTargetHostsFromLineByLineText(String sourcePath, HostsSourceType sourceType) throws TargetHostsLoadException {
        ArrayList<String> targetHosts = new ArrayList();
        try {
            String content = this.getContentFromPath(sourcePath, sourceType);
            targetHosts = this.setTargetHostsFromString(content);
        }
        catch (IOException e) {
            throw new TargetHostsLoadException("IEException when reading  " + sourcePath, e);
        }
        return targetHosts;
    }

    @Override
    public List<String> setTargetHostsFromCmsQueryUrl(String cmsQueryUrl) throws TargetHostsLoadException {
        ArrayList<String> targetHosts = new ArrayList();
        try {
            logger.info("will use default project label");
            targetHosts = this.setTargetHostsFromCmsQueryUrl(cmsQueryUrl, "label");
        }
        catch (Exception e) {
            throw new TargetHostsLoadException("error when reading  " + cmsQueryUrl, e);
        }
        return targetHosts;
    }

    @Override
    public List<String> setTargetHostsFromCmsQueryUrl(String cmsQueryUrl, String projection) {
        ArrayList<String> targetHosts = new ArrayList();
        try {
            if (projection == null || projection.isEmpty()) {
                logger.info("will use default project label");
                projection = "label";
            }
            TargetHostsBuilderHelperCms helper = new TargetHostsBuilderHelperCms();
            targetHosts = helper.getNodeListCompleteURLForCMS(cmsQueryUrl, projection);
        }
        catch (Exception e) {
            throw new TargetHostsLoadException("error when reading  " + cmsQueryUrl, e);
        }
        return targetHosts;
    }
}

