/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.actor;

import akka.actor.ActorSystem;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public final class ActorConfig {
    private static Config conf = null;
    private static ActorSystem actorSystem = null;
    private static AtomicInteger runningJobCount = new AtomicInteger(0);
    private static Logger logger = LoggerFactory.getLogger(ActorConfig.class);
    public static final FiniteDuration timeOutDuration;

    public static ActorSystem createAndGetActorSystem() {
        if (actorSystem == null || actorSystem.isTerminated()) {
            actorSystem = ActorSystem.create((String)"ParallecActorSystem", (Config)conf);
        }
        return actorSystem;
    }

    public static void shutDownActorSystemWhenNoJobRunning() {
        if (!actorSystem.isTerminated() && runningJobCount.get() == 0) {
            actorSystem.shutdown();
        }
    }

    public static void shutDownActorSystemForce() {
        if (!actorSystem.isTerminated()) {
            logger.info("shutting down actor system...");
            actorSystem.shutdown();
            actorSystem.awaitTermination((Duration)timeOutDuration);
            logger.info("Actor system has been shut down.");
        } else {
            logger.info("Actor system has been terminated already. NO OP.");
        }
    }

    public static FiniteDuration getTimeoutduration() {
        return timeOutDuration;
    }

    static {
        conf = ConfigFactory.load((String)"actorconfig.conf");
        logger.debug("Load Actor config {}", (Object)conf.toString());
        actorSystem = ActorSystem.create((String)"ParallecActorSystem", (Config)conf);
        timeOutDuration = Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS);
    }
}

