/*
 * Decompiled with CFR 0.152.
 */
package io.parallec.core.bean;

import io.parallec.core.ParallecResponseHandler;
import io.parallec.core.RequestProtocol;
import io.parallec.core.bean.ResponseHeaderMeta;
import io.parallec.core.bean.ping.PingMeta;
import io.parallec.core.bean.ssh.SshMeta;
import io.parallec.core.bean.tcp.TcpMeta;
import io.parallec.core.bean.udp.UdpMeta;
import io.parallec.core.resources.HttpMethod;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRequest {
    private static Logger logger = LoggerFactory.getLogger(TaskRequest.class);
    private final int actorMaxOperationTimeoutSec;
    private final String resourcePath;
    private final String requestContent;
    private final HttpMethod httpMethod;
    private final boolean pollable;
    private final Map<String, String> httpHeaderMap = new HashMap<String, String>();
    private final RequestProtocol protocol;
    private final String host;
    private final String hostUniform;
    private final int port;
    private final SshMeta sshMeta;
    private final TcpMeta tcpMeta;
    private final UdpMeta udpMeta;
    private final PingMeta pingMeta;
    private final ParallecResponseHandler handler;
    private final Map<String, Object> responseContext;
    private final ResponseHeaderMeta responseHeaderMeta;

    public TaskRequest(int actorMaxOperationTimeoutSec, RequestProtocol protocol, String host, String hostUniform, int port, String resourcePath, String requestContent, HttpMethod httpMethod, boolean pollable, Map<String, String> httpHeaderMap, ParallecResponseHandler handler, Map<String, Object> responseContext, SshMeta sshMeta, TcpMeta tcpMeta, UdpMeta udpMeta, PingMeta pingMeta, ResponseHeaderMeta responseHeaderMeta) {
        this.actorMaxOperationTimeoutSec = actorMaxOperationTimeoutSec;
        this.protocol = protocol;
        this.host = host;
        this.hostUniform = hostUniform;
        this.port = port;
        this.pollable = pollable;
        if (httpHeaderMap != null) {
            this.httpHeaderMap.putAll(httpHeaderMap);
        }
        this.resourcePath = resourcePath;
        this.requestContent = requestContent;
        this.httpMethod = httpMethod;
        this.handler = handler;
        this.responseContext = responseContext;
        this.sshMeta = sshMeta;
        this.tcpMeta = tcpMeta;
        this.udpMeta = udpMeta;
        this.pingMeta = pingMeta;
        this.responseHeaderMeta = responseHeaderMeta;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getPostData() {
        return this.requestContent;
    }

    public String getRequestContent() {
        return this.requestContent;
    }

    public boolean isPollable() {
        return this.pollable;
    }

    public String toString() {
        return "TaskRequest [actorMaxOperationTimeoutSec=" + this.actorMaxOperationTimeoutSec + ", resourcePath=" + this.resourcePath + ", requestContent=" + this.requestContent + ", httpMethod=" + (Object)((Object)this.httpMethod) + ", pollable=" + this.pollable + ", httpHeaderMap=" + this.httpHeaderMap + ", protocol=" + (Object)((Object)this.protocol) + ", host=" + this.host + ", hostUniform=" + this.hostUniform + ", port=" + this.port + ", sshMeta=" + this.sshMeta + ", tcpMeta=" + this.tcpMeta + ", udpMeta=" + this.udpMeta + ", pingMeta=" + this.pingMeta + ", handler=" + this.handler + ", responseContext=" + this.responseContext + ", responseHeaderMeta=" + this.responseHeaderMeta + "]";
    }

    public Map<String, String> getHttpHeaderMap() {
        return this.httpHeaderMap;
    }

    public RequestProtocol getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getHostUniform() {
        return this.hostUniform;
    }

    public int getPort() {
        return this.port;
    }

    public SshMeta getSshMeta() {
        return this.sshMeta;
    }

    public int getActorMaxOperationTimeoutSec() {
        return this.actorMaxOperationTimeoutSec;
    }

    public TcpMeta getTcpMeta() {
        return this.tcpMeta;
    }

    public PingMeta getPingMeta() {
        return this.pingMeta;
    }

    public ParallecResponseHandler getHandler() {
        return this.handler;
    }

    public Map<String, Object> getResponseContext() {
        return this.responseContext;
    }

    public UdpMeta getUdpMeta() {
        return this.udpMeta;
    }

    public ResponseHeaderMeta getResponseHeaderMeta() {
        return this.responseHeaderMeta;
    }
}

