/*
 * Decompiled with CFR 0.152.
 */
package io.packagecloud.client;

import io.packagecloud.client.interfaces.ProgressListener;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ProgressOutputStream
extends FilterOutputStream {
    long bytes = 0L;
    private final ProgressListener progressListener;
    private final String filename;

    public ProgressOutputStream(OutputStream out, ProgressListener progressListener, String filename) {
        super(out);
        this.progressListener = progressListener;
        this.filename = filename;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] arr = new byte[]{(byte)b};
        this.write(arr, 0, arr.length);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.bytes += (long)len;
        this.progressListener.update(this.bytes, this.filename);
    }
}

