/*
 * Decompiled with CFR 0.152.
 */
package io.packagecloud.client;

import io.packagecloud.client.Connection;
import io.packagecloud.client.Credentials;
import io.packagecloud.client.LoggerProvider;
import io.packagecloud.client.ProgressMonitor;
import io.packagecloud.client.Result;
import io.packagecloud.client.ServerErrorException;
import io.packagecloud.client.UnauthorizedException;
import io.packagecloud.client.interfaces.ProgressListener;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class Client
implements io.packagecloud.client.interfaces.Client {
    private static Logger logger = LoggerProvider.getLogger();
    private final HttpHost targetHost;
    private final CloseableHttpClient httpClient = this.getConfiguredHttpClient();
    private ProgressListener progressListener;
    private final HttpClientContext context = HttpClientContext.create();
    private final SecureRandom random = new SecureRandom();
    private final Credentials credentials;

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    private CloseableHttpClient getConfiguredHttpClient() {
        return HttpClients.custom().setUserAgent("io.packagecloud.client 3.0.0").build();
    }

    public Client(Credentials credentials) {
        this(credentials, new Connection());
    }

    public Client(Credentials credentials, Connection connection) {
        this.credentials = credentials;
        this.targetHost = new HttpHost(connection.getHost(), connection.getPort().intValue(), connection.getScheme());
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(this.targetHost, (AuthScheme)basicAuth);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "basic"), (org.apache.http.auth.Credentials)new UsernamePasswordCredentials(this.getToken(), ""));
        this.context.setCredentialsProvider((CredentialsProvider)credsProvider);
        this.context.setAuthCache((AuthCache)authCache);
    }

    public HttpHost getTargetHost() {
        return this.targetHost;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public String getToken() {
        return this.getCredentials().getToken();
    }

    public String getUsername() {
        return this.getCredentials().getUsername();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result getDistributions() throws UnauthorizedException, IOException, ServerErrorException {
        String strResponse;
        StatusLine statusLine;
        HttpGet httpGet = new HttpGet("/api/v1/distributions.json");
        CloseableHttpResponse response = this.httpClient.execute(this.targetHost, (HttpRequest)httpGet, (HttpContext)this.context);
        try {
            statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            strResponse = EntityUtils.toString((HttpEntity)entity);
            logger.info(response.getStatusLine().toString());
        }
        finally {
            response.close();
        }
        return this.getResultOrThrow(strResponse, statusLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result packageContents(InputStream fileStream, String filename, String repository, Integer distroVersionId) throws UnauthorizedException, IOException, ServerErrorException {
        String strResponse;
        StatusLine statusLine;
        String url = String.format("/api/v1/repos/%s/%s/packages/contents", this.getUsername(), repository);
        HttpPost httppost = new HttpPost(url);
        ByteArrayBody body = this.bodyFromInputStream(fileStream, filename);
        StringBody distro = new StringBody(String.valueOf(distroVersionId), ContentType.TEXT_PLAIN);
        HttpEntity reqEntity = MultipartEntityBuilder.create().addPart("package[package_file]", (ContentBody)body).addPart("package[distro_version_id]", (ContentBody)distro).build();
        httppost.setEntity(reqEntity);
        CloseableHttpResponse response = this.httpClient.execute(this.targetHost, (HttpRequest)httppost, (HttpContext)this.context);
        try {
            statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            strResponse = EntityUtils.toString((HttpEntity)entity);
            logger.info(response.getStatusLine().toString());
        }
        finally {
            response.close();
        }
        return this.getResultOrThrow(strResponse, statusLine);
    }

    public Result putPackage(InputStream fileStream, String filename, String repository, Integer distroVersionId, Map<String, InputStream> sourceFiles) throws UnauthorizedException, IOException, ServerErrorException {
        return this.putPackage(fileStream, filename, this.getUsername(), repository, distroVersionId, (Map)sourceFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result putPackage(InputStream fileStream, String filename, String username, String repository, Integer distroVersionId, Map<String, InputStream> sourceFiles) throws UnauthorizedException, IOException, ServerErrorException {
        String strResponse;
        StatusLine statusLine;
        String url = String.format("/api/v1/repos/%s/%s/packages.json", username, repository);
        HttpPost httppost = new HttpPost(url);
        ByteArrayBody body = this.bodyFromInputStream(fileStream, this.generateFilename());
        MultipartEntityBuilder reqEntity = MultipartEntityBuilder.create().addPart("package[package_file]", (ContentBody)body);
        if (distroVersionId != null) {
            StringBody distro = new StringBody(String.valueOf(distroVersionId), ContentType.TEXT_PLAIN);
            reqEntity.addPart("package[distro_version_id]", (ContentBody)distro);
        }
        if (sourceFiles != null) {
            for (String key : sourceFiles.keySet()) {
                logger.fine(String.format("Processing SourceFile part: %s", key));
                InputStream sourceStream = sourceFiles.get(key);
                ByteArrayBody sourceFileBody = this.bodyFromInputStream(sourceStream, key);
                reqEntity.addPart("package[source_files][]", (ContentBody)sourceFileBody);
            }
        }
        if (this.progressListener != null) {
            httppost.setEntity((HttpEntity)new ProgressMonitor(reqEntity.build(), this.progressListener, filename));
        } else {
            httppost.setEntity(reqEntity.build());
        }
        CloseableHttpResponse response = this.httpClient.execute(this.targetHost, (HttpRequest)httppost, (HttpContext)this.context);
        try {
            statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            strResponse = EntityUtils.toString((HttpEntity)entity);
            logger.info(response.getStatusLine().toString());
        }
        finally {
            response.close();
        }
        return this.getResultOrThrow(strResponse, statusLine);
    }

    private Result getResultOrThrow(String strResponse, StatusLine statusLine) throws UnauthorizedException, ServerErrorException {
        if (statusLine != null && (statusLine.getStatusCode() == 200 || statusLine.getStatusCode() == 201)) {
            return new Result(strResponse);
        }
        if (statusLine != null && statusLine.getStatusCode() == 401) {
            throw new UnauthorizedException();
        }
        String exception = String.format("%s:\n%s", statusLine, strResponse);
        throw new ServerErrorException(exception);
    }

    private ByteArrayBody bodyFromInputStream(InputStream is, String filename) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        return new ByteArrayBody(bytes, filename);
    }

    private String generateFilename() {
        return new BigInteger(130, this.random).toString(32);
    }
}

