/*
 * Decompiled with CFR 0.152.
 */
package io.packagecloud.client;

import io.packagecloud.client.LoggerProvider;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Logger;

public class Package {
    private static Logger logger = LoggerProvider.getLogger();
    private static String[] supportedExtensions = new String[]{"deb", "dsc", "gem", "rpm", "whl", "zip", "egg", "egg-info", "tar", "bz2", "Z", "gz"};
    private final InputStream filestream;
    private final String repository;
    private final Integer distroVersionId;
    private String filename;
    private Map<String, InputStream> sourceFiles;

    public Package(String filename, InputStream filestream, String repository) {
        this(filename, filestream, repository, null, null);
    }

    public Package(String filename, InputStream filestream, String repository, Integer distroVersionId) {
        this(filename, filestream, repository, distroVersionId, null);
    }

    public Package(String filename, byte[] bytes, String repository, Integer distroVersionId) {
        this(filename, new ByteArrayInputStream(bytes), repository, distroVersionId, null);
    }

    public Package(String filename, byte[] bytes, String repository) {
        this(filename, new ByteArrayInputStream(bytes), repository, null, null);
    }

    public Package(String filename, byte[] bytes, String repository, Integer distroVersionId, Map<String, InputStream> sourceFiles) {
        this(filename, new ByteArrayInputStream(bytes), repository, distroVersionId, sourceFiles);
    }

    public Package(String filename, InputStream filestream, String repository, Integer distroVersionId, Map<String, InputStream> sourceFiles) {
        logger.fine(String.format("new Package(%s, %s, %s, %s", filename, repository, distroVersionId, sourceFiles));
        if (filename == null) {
            throw new IllegalArgumentException("filename missing");
        }
        if (filestream == null) {
            throw new IllegalArgumentException("filestream missing");
        }
        if (repository == null) {
            throw new IllegalArgumentException("repository missing");
        }
        this.filestream = filestream;
        this.filename = filename;
        this.repository = repository;
        this.distroVersionId = distroVersionId;
        this.sourceFiles = sourceFiles;
    }

    public static Package fromFile(File file, String repository) throws FileNotFoundException {
        FileInputStream filestream = new FileInputStream(file);
        if (file.isDirectory() || !file.canRead()) {
            throw new IllegalArgumentException(String.format("could not open or read: %s", file.getName()));
        }
        return new Package(file.getName(), filestream, repository);
    }

    public static Package fromFile(File file, String repository, Integer distroVersionId) throws FileNotFoundException {
        FileInputStream filestream = new FileInputStream(file);
        if (file.isDirectory() || !file.canRead()) {
            throw new IllegalArgumentException(String.format("could not open or read: %s", file.getName()));
        }
        return new Package(file.getName(), filestream, repository, distroVersionId);
    }

    public static String[] getSupportedExtensions() {
        return supportedExtensions;
    }

    public String getRepository() {
        return this.repository;
    }

    public Integer getDistroVersionId() {
        return this.distroVersionId;
    }

    public InputStream getFilestream() {
        return this.filestream;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public Map<String, InputStream> getSourceFiles() {
        return this.sourceFiles;
    }

    public void setSourceFiles(Map<String, InputStream> sourceFiles) {
        this.sourceFiles = sourceFiles;
    }
}

